<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ResourceMenusTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_access_resource_pages()
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'member']);
        $admin = User::factory()->create(['email' => 'admin@test.com']);
        $this->actingAs($admin);
        
        $response = $this->get(route('admin.resources.press.index'));
        $response->assertStatus(200);
        $response->assertSee('Press');

        $response = $this->get(route('admin.resources.achievements'));
        $response->assertStatus(200);
        $response->assertSee('Achievements');

        $response = $this->get(route('admin.resources.gallery'));
        $response->assertStatus(200);
        $response->assertSee('Gallery');

        $response = $this->get(route('admin.resources.funeral-plan'));
        $response->assertStatus(200);
        $response->assertSee('Funeral Plan');

        $response = $this->get(route('admin.resources.documents'));
        $response->assertStatus(200);
        $response->assertSee('Documents');
    }
}
