<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class RbacTest extends TestCase
{
    /**
     * A basic feature test example.
     */
    use \Illuminate\Foundation\Testing\RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Clear cache before seeding to ensure fresh state
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();
        // Seed roles and permissions
        $this->seed(\Database\Seeders\RolesAndPermissionsSeeder::class);
    }

    public function test_super_admin_can_access_user_management()
    {
        $admin = \App\Models\User::factory()->create();
        $role = \Spatie\Permission\Models\Role::findByName('Super Admin', 'api');
        $admin->assignRole($role);

        $response = $this->actingAs($admin, 'api')->getJson('/api/users');

        $response->assertStatus(200);
    }

    public function test_regional_admin_can_access_user_management()
    {
        // Regional Admin has 'manage users' permission
        $user = \App\Models\User::factory()->create();
        $role = \Spatie\Permission\Models\Role::findByName('Regional Admin', 'api');
        $user->assignRole($role);

        $response = $this->actingAs($user, 'api')->getJson('/api/users');

        $response->assertStatus(200);
    }

    public function test_content_manager_cannot_access_user_management()
    {
        // Content Manager does NOT have 'manage users' permission
        $user = \App\Models\User::factory()->create();
        $role = \Spatie\Permission\Models\Role::findByName('Content Manager', 'api');
        $user->assignRole($role);

        $response = $this->actingAs($user, 'api')->getJson('/api/users');

        $response->assertStatus(403);
    }
}
