<?php

namespace Tests\Feature;

use App\Models\PressRelease;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Tests\TestCase;

class PressReleaseTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_create_press_release()
    {
        Storage::fake('public');

        $admin = User::factory()->create(['email' => 'admin@press.com']);
        $this->actingAs($admin);

        $file = UploadedFile::fake()->create('document.pdf', 100);

        $response = $this->post(route('admin.resources.press.store'), [
            'title' => 'New Statement',
            'body' => 'Important news.',
            'status' => 'published',
            'visibility' => 'public',
            'is_featured' => true,
            'attachments' => [$file],
        ]);

        $response->assertRedirect(route('admin.resources.press.index'));

        $this->assertDatabaseHas('press_releases', [
            'title' => 'New Statement',
            'is_featured' => true,
        ]);
        
        $release = PressRelease::first();
        $this->assertCount(1, $release->attachments);
        
        // Assert file exists
        // Storage::disk('public')->assertExists($release->attachments->first()->file_path);
    }

    public function test_index_shows_releases()
    {
        $admin = User::factory()->create();
        $this->actingAs($admin);

        PressRelease::create([
            'title' => 'Release 1',
            'body' => 'Content 1',
            'status' => 'draft'
        ]);

        $response = $this->get(route('admin.resources.press.index'));
        $response->assertSee('Release 1');
        $response->assertSee('Draft');
    }
}
