<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class FinanceMenusTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_access_finance_pages()
    {
        \Spatie\Permission\Models\Role::create(['name' => 'member']);
        $admin = User::factory()->create(['email' => 'admin@test.com']);
        $this->actingAs($admin);
        
        $response = $this->get(route('admin.finance.contributions'));
        $response->assertStatus(200);
        $response->assertSee('Contributions & Subscriptions');

        $response = $this->get(route('admin.finance.records'));
        $response->assertStatus(200);
        $response->assertSee('Payment Records');

        $response = $this->get(route('admin.finance.receipts'));
        $response->assertStatus(200);
        $response->assertSee('Receipts & Proof of Payment');
    }
}
