<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Tests\TestCase;

class FileTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_upload_file()
    {
        Storage::fake('local');

        $user = User::factory()->create();

        $file = UploadedFile::fake()->image('avatar.jpg');

        $response = $this->actingAs($user, 'api')->postJson('/api/files/upload', [
            'file' => $file,
        ]);

        $response->assertStatus(200)
            ->assertJson(['status' => 'success']);

        // Assert the file was stored...
        // Note: The controller returns a path. We should check if storage has it.
        // But since we use a random name, we might just rely on success response for now
        // or ensure the path returned exists.
        
        $path = $response->json('data.path');
        Storage::disk('local')->assertExists($path);
    }

    public function test_upload_validation_fails_for_invalid_file()
    {
        $user = User::factory()->create();

        $response = $this->actingAs($user, 'api')->postJson('/api/files/upload', [
            'file' => 'not-a-file',
        ]);

        $response->assertStatus(422)
            ->assertJsonStructure(['errors' => ['file']]);
    }
}
