<?php

namespace Tests\Feature;

use App\Models\User;
use App\Models\Grievance;
use App\Models\Fee;
use App\Models\Event;
use App\Models\Message;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Spatie\Permission\Models\Role;

class DashboardTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Seed roles if necessary, or just skip if not testing permissions deeply
        // $this->seed(\Database\Seeders\RolesAndPermissionsSeeder::class);
    }

    /** @test */
    public function it_returns_dashboard_stats()
    {
        $user = User::factory()->create();
        $this->actingAs($user, 'api');

        // Create data
        Grievance::create(['user_id' => $user->id, 'title' => 'G1', 'description' => 'D1', 'status' => 'pending']);
        Grievance::create(['user_id' => $user->id, 'title' => 'G2', 'description' => 'D2', 'status' => 'resolved']);
        
        Fee::create(['user_id' => $user->id, 'amount' => 100, 'status' => 'paid', 'date' => now()]);
        Fee::create(['user_id' => $user->id, 'amount' => 50, 'status' => 'pending', 'date' => now()]);

        Event::create(['title' => 'E1', 'date' => now()->addDay(), 'status' => 'upcoming']);
        Event::create(['title' => 'E2', 'date' => now()->subDay(), 'status' => 'completed']);

        $sender = User::factory()->create();
        Message::create(['sender_id' => $sender->id, 'receiver_id' => $user->id, 'content' => 'Hello', 'is_read' => false]);
        Message::create(['sender_id' => $sender->id, 'receiver_id' => $user->id, 'content' => 'Read', 'is_read' => true]);

        $response = $this->getJson('/api/dashboard/stats');

        $response->assertStatus(200)
            ->assertJson([
                'data' => [
                    'stats' => [
                        'active_grievances' => 1,
                        'fees_collected' => 100, // 100.00 might show as string or float
                        'upcoming_events' => 1,
                        'unread_messages' => 1,
                    ],
                    'recent_activity' => [],
                    'alerts' => [
                        'pending_grievances' => 1,
                    ]
                ]
            ]);
    }
}
