<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class AuditLogTest extends TestCase
{
    /**
     * A basic feature test example.
     */
    use \Illuminate\Foundation\Testing\RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->seed(\Database\Seeders\RolesAndPermissionsSeeder::class);
    }

    public function test_sensitive_actions_are_logged()
    {
        $admin = \App\Models\User::factory()->create();
        $admin->assignRole('Super Admin');

        // Perform an action that should be logged (e.g., create user)
        $this->actingAs($admin, 'api')->postJson('/api/users', [
            'name' => 'New User',
            'email' => 'new@example.com',
            'password' => 'password',
            'role' => 'Content Manager'
        ]);

        $this->assertDatabaseHas('audit_logs', [
            'user_id' => $admin->id,
            'action' => 'POST',
            'module' => 'api/users',
        ]);
    }

    public function test_admin_can_view_audit_logs()
    {
        $admin = \App\Models\User::factory()->create();
        $role = \Spatie\Permission\Models\Role::findByName('Super Admin', 'api');
        $admin->assignRole($role);

        $response = $this->actingAs($admin, 'api')->getJson('/api/audit-logs');

        $response->assertStatus(200);
    }

    public function test_unauthorized_user_cannot_view_audit_logs()
    {
        $user = \App\Models\User::factory()->create();
        // No role assigned, or a role without 'view reports'

        $response = $this->actingAs($user, 'api')->getJson('/api/audit-logs');

        $response->assertStatus(403);
    }
}
