<?php

namespace Tests\Feature;

use App\Models\Grievance;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ArchivedCasesTest extends TestCase
{
    use RefreshDatabase;

    public function test_index_shows_only_active_cases()
    {
        $admin = User::factory()->create(['email' => 'admin@test.com']);
        $this->actingAs($admin);
        
        $activeCase = Grievance::create([
            'user_id' => $admin->id,
            'title' => 'Active Case',
            'category' => 'other',
            'description' => 'Active',
            'incident_date' => now(),
            'urgency' => 'low',
            'status' => 'submitted',
        ]);

        $archivedCase = Grievance::create([
            'user_id' => $admin->id,
            'title' => 'Archived Case',
            'category' => 'other',
            'description' => 'Archived',
            'incident_date' => now(),
            'urgency' => 'low',
            // 'status' => 'archived' -- set via update to be safe
        ]);
        $archivedCase->update(['status' => 'archived']);

        $response = $this->get(route('admin.cases.index'));
        $response->assertStatus(200);
        
        $response->assertViewHas('cases', function ($cases) use ($activeCase, $archivedCase) {
            return $cases->contains($activeCase) && !$cases->contains($archivedCase);
        });
    }

    public function test_archived_route_shows_only_archived_cases()
    {
        $admin = User::factory()->create();
        $this->actingAs($admin);

        $activeCase = Grievance::create([
            'user_id' => $admin->id,
            'title' => 'Active Case',
            'category' => 'other',
            'description' => 'Active',
            'incident_date' => now(),
            'urgency' => 'low',
            'status' => 'submitted',
        ]);

        $archivedCase = Grievance::create([
            'user_id' => $admin->id,
            'title' => 'Archived Case',
            'category' => 'other',
            'description' => 'Archived',
            'incident_date' => now(),
            'urgency' => 'low',
        ]);
        $archivedCase->update(['status' => 'archived']);

        $response = $this->get(route('admin.cases.archived'));
        $response->assertStatus(200);
        
        $response->assertViewHas('cases', function ($cases) use ($activeCase, $archivedCase) {
             return $cases->contains($archivedCase) && !$cases->contains($activeCase);
        });
    }
}
