<?php

namespace Tests\Feature\Admin;

use App\Models\Setting;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class GlobalSettingsTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Create user
        $this->user = User::factory()->create();
        
        // Seed settings
        $this->seed(\Database\Seeders\SettingSeeder::class);
    }

    public function test_admin_can_view_settings()
    {
        $response = $this->actingAs($this->user)->get(route('admin.settings.index'));
        $response->assertStatus(200);
        $response->assertSee('Global Settings');
        $response->assertSee('MTWU Admin'); // Default value seeded
    }

    public function test_admin_can_update_settings()
    {
        $response = $this->actingAs($this->user)->put(route('admin.settings.update'), [
            'app_name' => 'New App Name',
            'enable_email_notifications' => '0', // Simulate unchecked checkbox (though controller handles missing key)
        ]);

        $response->assertRedirect();
        $response->assertSessionHas('success');

        $this->assertEquals('New App Name', Setting::get('app_name'));
    }
    
    public function test_boolean_setting_update()
    {
        // enable_push_notifications is 1 by default
        $this->assertEquals(1, Setting::get('enable_push_notifications'));
        
        // Update without sending the key (simulating unchecked checkbox)
        $response = $this->actingAs($this->user)->put(route('admin.settings.update'), [
            'app_name' => 'MTWU Admin',
            // enable_push_notifications missing
        ]);
        
        $this->assertEquals(0, Setting::get('enable_push_notifications'));
    }
}
