<?php

namespace Tests\Feature\Admin;

use App\Models\Event;
use App\Models\Grievance;
use App\Models\Member;
use App\Models\Message;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DashboardTest extends TestCase
{
    use RefreshDatabase;

    public function test_dashboard_displays_correct_counts()
    {
        // Create Admin User
        $admin = User::factory()->create([
            'email' => 'admin@example.com', 
            // Add any other required user fields that might not be in factory default if it fails
        ]);
        $this->actingAs($admin);

        // Create Data manually
        for ($i = 0; $i < 5; $i++) {
            Message::create([
                'sender_id' => $admin->id,
                'title' => 'Test Message ' . $i,
                'content' => 'Content',
                'type' => 'announcement',
                'status' => 'published',
                'published_at' => now(),
                'is_read' => true,
            ]);
        }
        Message::create([
             'sender_id' => $admin->id,
             'title' => 'Unread Message',
             'content' => 'Content',
             'type' => 'alert',
             'status' => 'published',
             'published_at' => now(),
             'is_read' => false,
        ]);
        
        // Members
        for ($i = 0; $i < 10; $i++) {
            Member::create([
                'first_name' => 'Member',
                'last_name' => $i,
                'email' => "member{$i}@test.com",
                'joined_at' => now(),
                'status' => 'approved',
                // required fields might trigger errors if not nullable.
                // Assuming minimal required or nullable. 
                // Based on model inspection earlier, fields are fillable but didn't check migration for nullable.
                // Will try minimal.
            ]);
        }
        
        // Grievances
        Grievance::create([
            'user_id' => $admin->id,
            'title' => 'Grievance 1',
            'description' => 'Desc',
            'status' => 'pending'
        ]);
        
        // Events
        Event::create([
            'title' => 'Upcoming Event',
            'event_type' => 'meeting',
            'start_time' => now()->addDays(2), 
            'end_time' => now()->addDays(2)->addHour(),
            'status' => 'published', 
            'published_at' => now()->subDay()
        ]);

        // Visit Dashboard
        $response = $this->get(route('dashboard'));

        $response->assertStatus(200);
        // We created 6 messages total (5 read, 1 unread)
        $response->assertViewHas('totalMessages', 6);
        $response->assertViewHas('unreadMessages', 1);
        $response->assertViewHas('activeCases', 1); 
        $response->assertViewHas('upcomingEvents', 1);
    }
}
