

<?php $__env->startSection('title', 'Documents'); ?>

<?php $__env->startSection('content'); ?>
    <div class="header">
        <div>
            <h1>Documents</h1>
            <p>Manage organizational documents, policies, and agreements.</p>
        </div>
        <div style="display: flex; gap: 1rem;">
            <a href="<?php echo e(route('admin.resources.document-categories.index')); ?>" class="btn" style="background: var(--dark-light); color: white;">Manage Categories</a>
            <a href="<?php echo e(route('admin.resources.documents.create')); ?>" class="btn btn-primary">Upload Document</a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card">
        <div style="margin-bottom: 1.5rem; display: flex; gap: 1rem; align-items: center;">
            <form method="GET" action="<?php echo e(route('admin.resources.documents.index')); ?>" style="display: flex; gap: 0.5rem; align-items: center;">
                <select name="category_id" class="form-control" style="width: 200px;" onchange="this.form.submit()">
                    <option value="">All Categories</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if(request('category_id')): ?>
                    <a href="<?php echo e(route('admin.resources.documents.index')); ?>" style="color: var(--danger); font-size: 0.9rem; text-decoration: none;">Clear Filter</a>
                <?php endif; ?>
            </form>
        </div>

        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Category</th>
                    <th style="padding: 1rem;">Access</th>
                    <th style="padding: 1rem;">Latest Version</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: 600;"><?php echo e($doc->title); ?></div>
                            <div style="font-size: 0.8rem; color: #777;"><?php echo e(Str::limit($doc->description, 50)); ?></div>
                        </td>
                        <td style="padding: 1rem;">
                            <?php if($doc->category): ?>
                                <span class="badge" style="background: #eef2ff; color: #4338ca;"><?php echo e($doc->category->name); ?></span>
                            <?php else: ?>
                                <span style="color: #ccc;">Uncategorized</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;">
                            <?php if($doc->access_level === 'public'): ?>
                                <span class="badge" style="background: #dcfce7; color: #16a34a;">Public</span>
                            <?php elseif($doc->access_level === 'members'): ?>
                                <span class="badge" style="background: #dbeafe; color: #2563eb;">Members Only</span>
                            <?php else: ?>
                                <span class="badge" style="background: #fee2e2; color: #dc2626;">Restricted</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem; font-size: 0.9rem;">
                            <?php if($doc->latestVersion): ?>
                                <div>v<?php echo e($doc->versions->count()); ?></div>
                                <div style="color: #777; font-size: 0.8rem;">
                                    <?php echo e($doc->latestVersion->created_at->format('M d, Y')); ?>

                                </div>
                            <?php else: ?>
                                <span style="color: #ccc;">-</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;">
                            <a href="<?php echo e(route('admin.resources.documents.show', $doc->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Manage</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No documents found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            <?php echo e($documents->withQueryString()->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/resources/documents/index.blade.php ENDPATH**/ ?>