

<?php $__env->startSection('title', 'Events | MTWU Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="header">
    <div>
        <h1>Events</h1>
        <p>Manage union meetings, rallies, and trainings.</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.events.create')); ?>" class="btn btn-primary">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
            Create Event
        </a>
    </div>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header" style="display: flex; gap: 1rem; border-bottom: 0;">
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'upcoming'])); ?>" 
           class="btn <?php echo e($filter == 'upcoming' ? 'btn-primary' : 'btn-outline'); ?>"
           style="border: none; border-bottom: <?php echo e($filter == 'upcoming' ? '2px solid #4f46e5' : '2px solid transparent'); ?>; border-radius: 0; padding: 0.5rem 1rem; background: none; color: <?php echo e($filter == 'upcoming' ? '#4f46e5' : '#64748b'); ?>;">
           Upcoming
        </a>
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'past'])); ?>" 
           class="btn <?php echo e($filter == 'past' ? 'btn-primary' : 'btn-outline'); ?>"
           style="border: none; border-bottom: <?php echo e($filter == 'past' ? '2px solid #4f46e5' : '2px solid transparent'); ?>; border-radius: 0; padding: 0.5rem 1rem; background: none; color: <?php echo e($filter == 'past' ? '#4f46e5' : '#64748b'); ?>;">
           Past
        </a>
        <a href="<?php echo e(route('admin.events.index', ['filter' => 'cancelled'])); ?>" 
           class="btn <?php echo e($filter == 'cancelled' ? 'btn-primary' : 'btn-outline'); ?>"
           style="border: none; border-bottom: <?php echo e($filter == 'cancelled' ? '2px solid #4f46e5' : '2px solid transparent'); ?>; border-radius: 0; padding: 0.5rem 1rem; background: none; color: <?php echo e($filter == 'cancelled' ? '#4f46e5' : '#64748b'); ?>;">
           Cancelled
        </a>
    </div>
    
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 1px solid #f1f5f9; color: #64748b; font-size: 0.85rem;">
                <th style="padding: 1rem;">Event</th>
                <th style="padding: 1rem;">Type</th>
                <th style="padding: 1rem;">When</th>
                <th style="padding: 1rem;">Location</th>
                <th style="padding: 1rem;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr style="border-bottom: 1px solid #f1f5f9;">
                <td style="padding: 1rem;">
                    <a href="<?php echo e(route('admin.events.show', $event)); ?>" style="text-decoration: none; color: #0f172a; font-weight: 500; display: block;">
                        <?php echo e($event->title); ?>

                    </a>
                </td>
                <td style="padding: 1rem;">
                    <span class="badge" style="background: rgba(79, 70, 229, 0.1); color: #4338ca; text-transform: capitalize;"><?php echo e($event->event_type); ?></span>
                </td>
                <td style="padding: 1rem;">
                    <div style="font-weight: 500; color: #0f172a;"><?php echo e($event->start_time->format('M d, Y')); ?></div>
                    <div style="font-size: 0.85rem; color: #64748b;"><?php echo e($event->start_time->format('H:i')); ?> - <?php echo e($event->end_time ? $event->end_time->format('H:i') : 'Late'); ?></div>
                </td>
                <td style="padding: 1rem; color: #64748b;">
                    <?php if($event->location): ?>
                        <div style="display: flex; align-items: center; gap: 4px;">
                             <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                             <?php echo e(Str::limit($event->location, 20)); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($event->virtual_link): ?>
                         <div style="display: flex; align-items: center; gap: 4px; margin-top: 4px;">
                             <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path></svg>
                             Virtual
                        </div>
                    <?php endif; ?>
                </td>
                <td style="padding: 1rem; display: flex; gap: 0.5rem;">
                    <a href="<?php echo e(route('admin.events.show', $event)); ?>" class="btn" style="padding: 0.4rem; color: #4f46e5;" title="View">
                         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                    </a>
                    
                    <?php if($event->status !== 'cancelled'): ?>
                        <a href="<?php echo e(route('admin.events.edit', $event)); ?>" class="btn" style="padding: 0.4rem; color: #64748b;" title="Edit">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
                        </a>
                        
                        <form action="<?php echo e(route('admin.events.duplicate', $event)); ?>" method="POST" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn" style="padding: 0.4rem; color: #0891b2;" title="Duplicate">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path></svg>
                            </button>
                        </form>

                        <form action="<?php echo e(route('admin.events.destroy', $event)); ?>" method="POST" onsubmit="return confirm('Delete this event?');" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn" style="padding: 0.4rem; color: #ef4444;" title="Delete">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path></svg>
                            </button>
                        </form>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" style="padding: 2rem; text-align: center; color: #94a3b8;">
                    No events found.
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div style="padding: 1rem;">
        <?php echo e($events->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/events/index.blade.php ENDPATH**/ ?>