

<?php $__env->startSection('title', 'Contributions & Subscriptions'); ?>

<?php $__env->startSection('content'); ?>
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Contributions & Subscriptions</h1>
        <a href="<?php echo e(route('admin.finance.fee-structures.index')); ?>" class="btn" style="background: white; border: 1px solid #ccc; color: #333;">Manage Fee Structures</a>
    </div>

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Member</th>
                    <th style="padding: 1rem;">Subscription</th>
                    <th style="padding: 1rem;">Balance</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: bold;"><?php echo e($member->name); ?></div>
                            <div style="font-size: 0.85rem; color: #666;"><?php echo e($member->email); ?></div>
                        </td>
                        <td style="padding: 1rem;">
                            <?php $__empty_2 = true; $__currentLoopData = $member->subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                <div style="font-size: 0.9rem;"><?php echo e($sub->feeStructure->name); ?> (<?php echo e(ucfirst($sub->feeStructure->frequency)); ?>)</div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                <span style="color: #999;">No active subscription</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;">
                            <?php if($member->balance > 0): ?>
                                <span style="color: #dc2626; font-weight: bold;">-R <?php echo e(number_format($member->balance, 2)); ?></span>
                            <?php else: ?>
                                <span style="color: #16a34a; font-weight: bold;">Paid Up</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8rem;
                                background: <?php echo e($member->status === 'Arrears' ? '#fee2e2' : '#dcfce7'); ?>;
                                color: <?php echo e($member->status === 'Arrears' ? '#dc2626' : '#16a34a'); ?>;">
                                <?php echo e($member->status); ?>

                            </span>
                        </td>
                        <td style="padding: 1rem;">
                            <a href="<?php echo e(route('admin.finance.member-history', $member->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">View History</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No members found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            <?php echo e($members->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/finance/contributions.blade.php ENDPATH**/ ?>