

<?php $__env->startSection('title', 'Press Releases'); ?>

<?php $__env->startSection('content'); ?>
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Press Releases</h1>
        <a href="<?php echo e(route('admin.resources.press.create')); ?>" class="btn btn-primary">Create Press Release</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Visibility</th>
                    <th style="padding: 1rem;">Published Date</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $releases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $release): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: bold;"><?php echo e($release->title); ?></div>
                            <?php if($release->is_featured): ?>
                                <span class="badge" style="background: #fef08a; color: #854d0e; font-size: 0.75rem; padding: 2px 6px; border-radius: 4px;">Featured</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="
                                padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8rem;
                                background: <?php echo e($release->status === 'published' ? '#dcfce7' : '#f3f4f6'); ?>;
                                color: <?php echo e($release->status === 'published' ? '#16a34a' : '#4b5563'); ?>;
                            ">
                                <?php echo e(ucfirst($release->status)); ?>

                            </span>
                        </td>
                        <td style="padding: 1rem;"><?php echo e(ucfirst($release->visibility)); ?></td>
                        <td style="padding: 1rem;">
                            <?php echo e($release->published_at ? $release->published_at->format('M d, Y') : '-'); ?>

                        </td>
                        <td style="padding: 1rem;">
                            <a href="<?php echo e(route('admin.resources.press.edit', $release->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Edit</a>
                            <form action="<?php echo e(route('admin.resources.press.destroy', $release->id)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Delete this release?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #ef4444; color: white;">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No press releases found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            <?php echo e($releases->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/resources/press/index.blade.php ENDPATH**/ ?>