

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1><?php echo e($title); ?></h1>
        <a href="<?php echo e(route('admin.cases.create')); ?>" class="btn btn-primary">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
            Open New Case
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success" style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Reference</th>
                    <th style="padding: 1rem;">Member</th>
                    <th style="padding: 1rem;">Category</th>
                    <th style="padding: 1rem;">Urgency</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Date</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $cases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem; font-weight: bold;"><?php echo e($case->reference_number); ?></td>
                        <td style="padding: 1rem;">
                            <?php if($case->user): ?>
                                <?php echo e($case->user->first_name); ?> <?php echo e($case->user->last_name); ?>

                            <?php else: ?>
                                <span style="color: #999;">Unknown User</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 1rem;"><?php echo e(ucfirst(str_replace('_', ' ', $case->category))); ?></td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="
                                padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8em;
                                background: <?php echo e($case->urgency == 'critical' ? '#ffebe6' : ($case->urgency == 'high' ? '#fff4e5' : '#e6fcff')); ?>;
                                color: <?php echo e($case->urgency == 'critical' ? '#bf2600' : ($case->urgency == 'high' ? '#b76e00' : '#006644')); ?>;
                            ">
                                <?php echo e(ucfirst($case->urgency)); ?>

                            </span>
                        </td>
                        <td style="padding: 1rem;"><?php echo e(ucfirst($case->status)); ?></td>
                        <td style="padding: 1rem;"><?php echo e($case->created_at->format('Y-m-d')); ?></td>
                        <td style="padding: 1rem;">
                            <div style="display: flex; gap: 0.5rem;">
                                <a href="<?php echo e(route('admin.cases.show', $case->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #e2e8f0; color: #475569;">View</a>
                                <a href="<?php echo e(route('admin.cases.edit', $case->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Edit</a>
                                <?php if($case->status !== 'archived'): ?>
                                <form action="<?php echo e(route('admin.cases.archive', $case->id)); ?>" method="POST" onsubmit="return confirm('Archive this case?');" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #64748b; color: white;">Archive</button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" style="padding: 2rem; text-align: center; color: #777;">No cases found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div style="padding: 1rem;">
            <?php echo e($cases->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/cases/index.blade.php ENDPATH**/ ?>