

<?php $__env->startSection('title', 'Fee Structures'); ?>

<?php $__env->startSection('content'); ?>
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Fee Structures</h1>
        <a href="<?php echo e(route('admin.finance.fee-structures.create')); ?>" class="btn btn-primary">Create New Structure</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Name</th>
                    <th style="padding: 1rem;">Amount</th>
                    <th style="padding: 1rem;">Frequency</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem; font-weight: bold;"><?php echo e($structure->name); ?></td>
                        <td style="padding: 1rem;">R <?php echo e(number_format($structure->amount, 2)); ?></td>
                        <td style="padding: 1rem;"><?php echo e(ucfirst($structure->frequency)); ?></td>
                        <td style="padding: 1rem;">
                            <a href="<?php echo e(route('admin.finance.fee-structures.edit', $structure->id)); ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Edit</a>
                            <form action="<?php echo e(route('admin.finance.fee-structures.destroy', $structure->id)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Delete this structure?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #ef4444; color: white;">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" style="padding: 2rem; text-align: center; color: #777;">No fee structures defined.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Projects\MTWU\resources\views/admin/finance/fees/index.blade.php ENDPATH**/ ?>