<?php

use Illuminate\Support\Facades\Route;


// Installer Routes
Route::group(['prefix' => 'install', 'as' => 'installer.', 'middleware' => ['web', 'installed']], function () {
    Route::get('/', [\App\Http\Controllers\InstallerController::class, 'welcome'])->name('welcome');
    Route::get('requirements', [\App\Http\Controllers\InstallerController::class, 'requirements'])->name('requirements');
    Route::get('permissions', [\App\Http\Controllers\InstallerController::class, 'permissions'])->name('permissions');
    Route::get('environment', [\App\Http\Controllers\InstallerController::class, 'environment'])->name('environment');
    Route::post('environment/save', [\App\Http\Controllers\InstallerController::class, 'saveEnvironment'])->name('environmentSave');
    Route::get('overview', [\App\Http\Controllers\InstallerController::class, 'overview'])->name('overview');
    Route::get('install', [\App\Http\Controllers\InstallerController::class, 'install'])->name('install');
    Route::get('admin', [\App\Http\Controllers\InstallerController::class, 'adminSetup'])->name('admin');
    Route::post('admin/create', [\App\Http\Controllers\InstallerController::class, 'createAdmin'])->name('adminCreate');
    Route::get('finish', [\App\Http\Controllers\InstallerController::class, 'finish'])->name('finish');
});

// Authentication Routes
Route::get('login', [\App\Http\Controllers\AuthController::class, 'showLogin'])->name('login');
Route::post('login', [\App\Http\Controllers\AuthController::class, 'login'])->name('login.post');
Route::get('register', [\App\Http\Controllers\AuthController::class, 'showRegister'])->name('register');
Route::post('register', [\App\Http\Controllers\AuthController::class, 'register'])->name('register.post');
Route::post('logout', [\App\Http\Controllers\AuthController::class, 'logout'])->name('logout');

// Main App Routes (Protected by 'installed' and 'auth')
Route::middleware(['web', 'installed', 'auth'])->group(function () {
    Route::get('/', function () {
        return redirect()->route('dashboard');
    });


    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');


    // Membership Routes
    // Membership Routes
    Route::get('/members/export', [\App\Http\Controllers\MemberController::class, 'export'])->name('members.export');
    Route::patch('/members/{member}/suspend', [\App\Http\Controllers\MemberController::class, 'suspend'])->name('members.suspend');
    Route::patch('/members/{id}/reactivate', [\App\Http\Controllers\MemberController::class, 'reactivate'])->name('members.reactivate');
    Route::post('/members/{id}/restore', [\App\Http\Controllers\MemberController::class, 'restore'])->name('members.restore');
    
    // Explicitly define edit and update to handle soft deletes (before resource)
    Route::get('/members/{id}/edit', [\App\Http\Controllers\MemberController::class, 'edit'])->name('members.edit');
    Route::put('/members/{id}', [\App\Http\Controllers\MemberController::class, 'update'])->name('members.update');
    
    Route::resource('members', \App\Http\Controllers\MemberController::class)->except(['edit', 'update']);

    // Communication Routes
    Route::get('admin/messages/archived', [\App\Http\Controllers\Admin\MessageController::class, 'archived'])->name('admin.messages.archived');
    Route::post('admin/messages/{id}/restore', [\App\Http\Controllers\Admin\MessageController::class, 'restore'])->name('admin.messages.restore');
    Route::resource('admin/messages', \App\Http\Controllers\Admin\MessageController::class, ['as' => 'admin']);
    Route::post('admin/messages/{message}/recall', [\App\Http\Controllers\Admin\MessageController::class, 'recall'])->name('admin.messages.recall');
    Route::post('admin/messages/{message}/recall', [\App\Http\Controllers\Admin\MessageController::class, 'recall'])->name('admin.messages.recall');
    Route::post('admin/messages/{message}/resend', [\App\Http\Controllers\Admin\MessageController::class, 'resend'])->name('admin.messages.resend');

    // Event Management Routes
    Route::post('admin/events/{event}/cancel', [\App\Http\Controllers\Admin\EventController::class, 'cancel'])->name('admin.events.cancel');
    // Global Settings
    Route::get('/settings', [App\Http\Controllers\Admin\SettingController::class, 'index'])->name('admin.settings.index');
    Route::put('/settings', [App\Http\Controllers\Admin\SettingController::class, 'update'])->name('admin.settings.update');

    // Case Management
    Route::get('admin/cases/archived', [\App\Http\Controllers\Admin\CaseController::class, 'archived'])->name('admin.cases.archived');
    Route::post('admin/cases/{id}/archive', [\App\Http\Controllers\Admin\CaseController::class, 'archive'])->name('admin.cases.archive');
    Route::resource('admin/cases', \App\Http\Controllers\Admin\CaseController::class, ['as' => 'admin']);

    // Finance Management
    Route::prefix('admin/finance')->name('admin.finance.')->group(function () {
        Route::get('contributions', [\App\Http\Controllers\Admin\FinanceController::class, 'contributions'])->name('contributions');
        Route::get('contributions/{id}', [\App\Http\Controllers\Admin\FinanceController::class, 'memberHistory'])->name('member-history');
        Route::get('records', [\App\Http\Controllers\Admin\FinanceController::class, 'records'])->name('records');
        Route::get('receipts', [\App\Http\Controllers\Admin\FinanceController::class, 'receipts'])->name('receipts');
        
        Route::resource('fee-structures', \App\Http\Controllers\Admin\FeeStructureController::class);
    });

    // Organization Master Data
    Route::get('/organization', [App\Http\Controllers\Admin\OrganizationController::class, 'index'])->name('admin.organization.index');
    
    Route::post('/organization/provinces', [App\Http\Controllers\Admin\OrganizationController::class, 'storeProvince'])->name('admin.organization.provinces.store');
    Route::put('/organization/provinces/{province}', [App\Http\Controllers\Admin\OrganizationController::class, 'updateProvince'])->name('admin.organization.provinces.update');
    Route::delete('/organization/provinces/{province}', [App\Http\Controllers\Admin\OrganizationController::class, 'destroyProvince'])->name('admin.organization.provinces.destroy');

    Route::post('/organization/regions', [App\Http\Controllers\Admin\OrganizationController::class, 'storeRegion'])->name('admin.organization.regions.store');
    Route::put('/organization/regions/{region}', [App\Http\Controllers\Admin\OrganizationController::class, 'updateRegion'])->name('admin.organization.regions.update');
    Route::delete('/organization/regions/{region}', [App\Http\Controllers\Admin\OrganizationController::class, 'destroyRegion'])->name('admin.organization.regions.destroy');

    Route::post('/organization/branches', [App\Http\Controllers\Admin\OrganizationController::class, 'storeBranch'])->name('admin.organization.branches.store');
    Route::put('/organization/branches/{branch}', [App\Http\Controllers\Admin\OrganizationController::class, 'updateBranch'])->name('admin.organization.branches.update');
    Route::delete('/organization/branches/{branch}', [App\Http\Controllers\Admin\OrganizationController::class, 'destroyBranch'])->name('admin.organization.branches.destroy');

    Route::post('admin/events/{event}/duplicate', [\App\Http\Controllers\Admin\EventController::class, 'duplicate'])->name('admin.events.duplicate');
    Route::resource('admin/events', \App\Http\Controllers\Admin\EventController::class, ['as' => 'admin']);

    // Resources Management
    Route::prefix('admin/resources')->name('admin.resources.')->group(function () {
        // Press Release Resource (using standard resource controller)
        // Parameter needs to be consistent: 'press-releases' -> $pressRelease
        // But we want URL to include 'press' maybe? 
        // Let's use 'press' as parameter name to accept 'PressRelease' binding if we align it.
        // Actually, let's keep it simple: admin/resources/press
        Route::resource('press', \App\Http\Controllers\Admin\PressReleaseController::class)->parameters(['press' => 'pressRelease']);
        
        Route::get('achievements', [\App\Http\Controllers\Admin\ResourceController::class, 'achievements'])->name('achievements');
        Route::get('gallery', [\App\Http\Controllers\Admin\ResourceController::class, 'gallery'])->name('gallery');
        Route::get('funeral-plan', [\App\Http\Controllers\Admin\ResourceController::class, 'funeralPlan'])->name('funeral-plan');
        
        Route::resource('documents', \App\Http\Controllers\Admin\DocumentController::class);
        Route::post('documents/{document}/versions', [\App\Http\Controllers\Admin\DocumentController::class, 'storeVersion'])->name('documents.version.store');
        Route::resource('document-categories', \App\Http\Controllers\Admin\DocumentCategoryController::class);
    });

    // User Management
    Route::patch('/users/{user}/suspend', [\App\Http\Controllers\UserController::class, 'suspend'])->name('users.suspend');
    Route::patch('/users/{user}/activate', [\App\Http\Controllers\UserController::class, 'activate'])->name('users.activate');
    Route::resource('users', \App\Http\Controllers\UserController::class);
});

