<?php

use App\Http\Controllers\AuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');

Route::group([
    'middleware' => 'api',
    'prefix' => 'auth'
], function ($router) {
    Route::post('register', [\App\Http\Controllers\Api\AuthController::class, 'register']);
    Route::post('login', [\App\Http\Controllers\Api\AuthController::class, 'login']);
    Route::post('logout', [\App\Http\Controllers\Api\AuthController::class, 'logout']);
    Route::post('refresh', [\App\Http\Controllers\Api\AuthController::class, 'refresh']);
    Route::get('me', [\App\Http\Controllers\Api\AuthController::class, 'me'])->middleware('auth:api');
});

Route::middleware('auth:api')->group(function () {
    Route::post('files/upload', [\App\Http\Controllers\FileController::class, 'upload']);
    Route::post('notifications/send', [\App\Http\Controllers\NotificationController::class, 'send']);

    // Admin & Management Routes
    Route::apiResource('users', \App\Http\Controllers\Api\UserController::class)->names('api.users');
    Route::post('users/{id}/reset-password', [\App\Http\Controllers\Api\UserController::class, 'resetPassword']);
    
    Route::apiResource('audit-logs', \App\Http\Controllers\Api\AuditLogController::class)->only(['index', 'show']);
    Route::get('dashboard/stats', [\App\Http\Controllers\Api\DashboardController::class, 'stats']);
});

// Mobile App Routes (Public/Guest)
Route::post('members/validate', [\App\Http\Controllers\Api\MemberController::class, 'validateMember']);
Route::post('members/login', [\App\Http\Controllers\Api\MemberController::class, 'login']);

// Mobile App Routes (Protected)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('members/update', [\App\Http\Controllers\Api\MemberController::class, 'updateProfile']);
    Route::get('members/me', function (Request $request) {
        return $request->user();
    });
    Route::post('cases', [\App\Http\Controllers\Api\CaseController::class, 'store']);
});
