                    @forelse($members as $member)
                        <tr style="border-bottom: 1px solid #f1f5f9;">
                            <td style="padding: 1rem;">
                                <span style="background: #f1f5f9; padding: 0.25rem 0.5rem; border-radius: 4px; font-family: monospace; font-size: 0.85rem;">
                                    {{ $member->digital_id ?? 'N/A' }}
                                </span>
                            </td>
                            <td style="padding: 1rem;">
                                <div style="font-weight: 600; color: var(--dark);">{{ $member->first_name }}</div>
                            </td>
                            <td style="padding: 1rem;">
                                <div style="font-weight: 600; color: var(--dark);">{{ $member->last_name }}</div>
                            </td>
                            <td style="padding: 1rem;">
                                {{ $member->identity_number ?? '-' }}
                            </td>
                            <td style="padding: 1rem;">
                                @if($member->trashed())
                                    <span class="badge badge-danger" style="background: #fee2e2; color: #991b1b; border: 1px solid #fecaca;">Deleted</span>
                                @elseif($member->status == 'approved')
                                    <span class="badge badge-success">Active</span>
                                @elseif($member->status == 'pending')
                                    <span class="badge" style="background: rgba(234, 179, 8, 0.1); color: #ca8a04;">Pending</span>
                                @elseif($member->status == 'suspended')
                                    <span class="badge" style="background: rgba(239, 68, 68, 0.1); color: var(--danger);">Suspended</span>
                                @else
                                    <span class="badge badge-danger">Rejected</span>
                                @endif
                            </td>
                            <td style="padding: 1rem;">
                                {{ $member->home_province ?? $member->postal_province ?? '-' }}
                            </td>
                            <td style="padding: 1rem; text-align: right; position: relative;">
                                <div class="action-dropdown" style="position: relative; display: inline-block;">
                                    <button onclick="openContextMenu(event, {{ $member->id }}, '{{ route('members.edit', $member->id) }}')" class="action-btn" style="padding: 0.4rem 0.8rem; background: transparent; color: var(--text-light); border: 1px solid var(--border); border-radius: 8px; cursor: pointer; display: inline-flex; align-items: center; transition: all 0.2s;">
                                        Actions
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-left: 0.5rem;"><polyline points="6 9 12 15 18 9"></polyline></svg>
                                    </button>
                                    
                                    <form id="restore-form-{{ $member->id }}" action="{{ route('members.restore', $member->id) }}" method="POST" style="display: none;">
                                        @csrf
                                    </form>
                                    <form id="suspend-form-{{ $member->id }}" action="{{ route('members.suspend', $member->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('PATCH')
                                    </form>
                                    <form id="delete-form-{{ $member->id }}" action="{{ route('members.destroy', $member->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                    <form id="reactivate-form-{{ $member->id }}" action="{{ route('members.reactivate', $member->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('PATCH')
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" style="padding: 3rem; text-align: center; color: var(--text-light);">
                                No members found.
                            </td>
                        </tr>
                    @endforelse
