@extends('layouts.admin')

@section('content')
<div style="max-width: 1200px; margin: 0 auto;">
    <div class="header" style="background: none; text-align: left; padding: 0; margin-bottom: 2rem; color: var(--dark);">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <h1 style="color: var(--dark); font-size: 1.8rem;">Membership Management</h1>
                <p style="color: var(--text-light);">Manage all registered members</p>
            </div>
            <div style="display: flex; gap: 1rem;">
                <button onclick="window.location.reload()" class="btn" style="background: white; color: var(--text); border: 1px solid var(--border);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 12a9 9 0 0 0-9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"></path><path d="M3 3v5h5"></path><path d="M3 12a9 9 0 0 0 9 9 9.75 9.75 0 0 0 6.74-2.74L21 16"></path><path d="M16 21h5v-5"></path></svg>
                    Refresh
                </button>
                <a href="{{ route('members.export') }}" class="btn" style="background: white; color: var(--text); border: 1px solid var(--border);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>
                    Export CSV
                </a>
                <a href="{{ route('members.create') }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                    Add Member
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card" style="background: white; border-radius: 16px; padding: 1.5rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);">
        




        <div style="overflow-x: auto;">
            <form id="filter-form" method="GET" action="{{ route('members.index') }}">
                <table style="width: 100%; border-collapse: collapse; font-size: 0.95rem;">
                    <thead>
                        <tr style="border-bottom: 2px solid #f1f5f9; text-align: left; color: #64748b;">
                            <th style="padding: 1rem;">Membership No.</th>
                            <th style="padding: 1rem;">Name</th>
                            <th style="padding: 1rem;">Surname</th>
                            <th style="padding: 1rem;">ID Number</th>
                            <th style="padding: 1rem;">Status</th>
                            <th style="padding: 1rem;">Province</th>
                            <th style="padding: 1rem; text-align: right;">Actions</th>
                        </tr>
                        <!-- Search Filter Row -->
                        <tr style="background: #f8fafc;">
                            <th style="padding: 0.5rem 1rem;">
                                <input type="text" name="digital_id" value="{{ request('digital_id') }}" placeholder="Search..." autocomplete="off" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <input type="text" name="first_name" value="{{ request('first_name') }}" placeholder="Search..." autocomplete="off" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <input type="text" name="last_name" value="{{ request('last_name') }}" placeholder="Search..." autocomplete="off" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <input type="text" name="identity_number" value="{{ request('identity_number') }}" placeholder="Search..." autocomplete="off" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <select name="status" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                                    <option value="all">All</option>
                                    <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Active</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="suspended" {{ request('status') == 'suspended' ? 'selected' : '' }}>Suspended</option>
                                    <option value="trash" {{ request('status') == 'trash' ? 'selected' : '' }}>Deleted</option>
                                </select>
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <input type="text" name="province" value="{{ request('province') }}" placeholder="Search..." autocomplete="off" style="width: 100%; padding: 0.4rem; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.85rem;">
                            </th>
                            <th style="padding: 0.5rem 1rem;">
                                <!-- Actions column empty -->
                                @if(request()->hasAny(['digital_id', 'first_name', 'last_name', 'identity_number', 'status', 'province']))
                                    <button type="button" onclick="window.location.href='{{ route('members.index') }}'" title="Clear Filters" style="background: none; border: none; color: var(--danger); font-size: 0.85rem; cursor: pointer;">&times; Clear</button>
                                @endif
                            </th>
                        </tr>
                    </thead>
                    <tbody id="members-table-body">
                        @include('members.partials.table_rows')
                    </tbody>
                </table>
            </form>
        </div>
        
        <div id="pagination-container" style="margin-top: 1.5rem;">
            {{ $members->links() }}
        </div>
    </div>
</div>

<!-- Global Context Menu -->
<div id="globalContextMenu" style="display: none; position: fixed; background: white; border: 1px solid var(--border); border-radius: 12px; box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1); width: 160px; z-index: 9999; overflow: hidden; padding: 0.5rem 0;">
    @if(request('status') == 'trash')
        <button onclick="triggerGlobalAction('restore')" style="display: flex; width: 100%; align-items: center; gap: 0.75rem; text-align: left; padding: 0.6rem 1rem; color: var(--success); background: none; border: none; font-size: 0.9rem; cursor: pointer; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path></svg>
            Restore
        </button>
        <a id="contextEditLink" href="#" style="display: flex; align-items: center; gap: 0.75rem; padding: 0.6rem 1rem; color: var(--text); text-decoration: none; font-size: 0.9rem; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--primary);"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
            Edit
        </a>
    @else
        <a id="contextEditLink" href="#" style="display: flex; align-items: center; gap: 0.75rem; padding: 0.6rem 1rem; color: var(--text); text-decoration: none; font-size: 0.9rem; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--primary);"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
            Edit
        </a>
        <button onclick="triggerGlobalAction('suspend')" style="display: flex; width: 100%; align-items: center; gap: 0.75rem; text-align: left; padding: 0.6rem 1rem; color: #ca8a04; background: none; border: none; font-size: 0.9rem; cursor: pointer; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            Suspend
        </button>
        <div style="height: 1px; background: #f1f5f9; margin: 0.4rem 0;"></div>
        <button onclick="triggerGlobalAction('delete')" style="display: flex; width: 100%; align-items: center; gap: 0.75rem; text-align: left; padding: 0.6rem 1rem; color: var(--danger); background: none; border: none; font-size: 0.9rem; cursor: pointer; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path></svg>
            Delete
        </button>
        <button onclick="triggerGlobalAction('reactivate')" style="display: flex; width: 100%; align-items: center; gap: 0.75rem; text-align: left; padding: 0.6rem 1rem; color: var(--success); background: none; border: none; font-size: 0.9rem; cursor: pointer; transition: background 0.2s;">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"></polyline></svg>
            Re-activate
        </button>
    @endif
</div>

<!-- Confirmation Modal -->
<div id="confirmationModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; padding: 2rem; border-radius: 16px; width: 90%; max-width: 400px; text-align: center; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);">
        <div style="width: 50px; height: 50px; background: rgba(239, 68, 68, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1.5rem;">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="var(--danger)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>
        </div>
        <h3 style="color: var(--dark); margin-bottom: 0.5rem; font-size: 1.25rem;">Are you sure?</h3>
        <p style="color: var(--text-light); margin-bottom: 2rem; font-size: 0.95rem;">This action cannot be undone. Please confirm you want to proceed.</p>
        
        <div style="display: flex; gap: 1rem;">
            <button onclick="closeModal()" class="btn" style="flex: 1; justify-content: center; background: #f1f5f9; color: var(--text); border: none;">Cancel</button>
            <button id="confirmBtn" class="btn btn-danger" style="flex: 1; justify-content: center;">Confirm</button>
        </div>
    </div>
</div>

<script>
    let activeMemberId = null;

    // Open Context Menu
    function openContextMenu(event, memberId, editUrl) {
        event.stopPropagation();
        activeMemberId = memberId;
        
        const menu = document.getElementById('globalContextMenu');
        const editLink = document.getElementById('contextEditLink');
        const btnRect = event.currentTarget.getBoundingClientRect();
        
        // Update Edit Link if exists
        if (editLink) {
            editLink.href = editUrl;
        }
        
        // Position Menu (fixed positioning relative to viewport)
        // Position to the left of the button
        menu.style.top = btnRect.top + 'px';
        menu.style.left = (btnRect.left - 170) + 'px'; // 160 width + 10 margin
        menu.style.display = 'block';
    }

    // Trigger Action from Global Menu
    function triggerGlobalAction(action) {
        confirmAction(action, activeMemberId);
    }

    // Existing Confirmation Logic
    let currentAction = null;
    let currentId = null;

    function confirmAction(action, id) {
        currentAction = action;
        currentId = id;
        
        document.getElementById('confirmationModal').style.display = 'flex';
        document.getElementById('globalContextMenu').style.display = 'none';
    }

    function closeModal() {
        document.getElementById('confirmationModal').style.display = 'none';
        currentAction = null;
        currentId = null;
    }

    document.getElementById('confirmBtn').addEventListener('click', function() {
        if (currentAction && currentId) {
            document.getElementById(`${currentAction}-form-${currentId}`).submit();
        }
        closeModal();
    });

    // Close menu when clicking outside
    document.addEventListener('click', function(e) {
        const menu = document.getElementById('globalContextMenu');
        if (!e.target.closest('#globalContextMenu') && !e.target.closest('.action-btn')) {
            menu.style.display = 'none';
        }
    });

    // Live Search Logic
    let searchTimeout;

    function debounce(func, wait) {
        return function(...args) {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => func.apply(this, args), wait);
        };
    }

    const filterForm = document.getElementById('filter-form');
    const inputs = filterForm.querySelectorAll('input, select');

    function fetchMembers() {
        const formData = new FormData(filterForm);
        const params = new URLSearchParams(formData);
        const tableBody = document.getElementById('members-table-body');

        // Update URL without reloading
        window.history.pushState({}, '', '?' + params.toString());

        // visual feedback
        tableBody.style.opacity = '0.5';

        fetch('{{ route("members.index") }}?' + params.toString(), {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.json();
        })
        .then(data => {
            tableBody.style.opacity = '1';
            tableBody.innerHTML = data.html;
            const paginationContainer = document.getElementById('pagination-container');
            if (paginationContainer) {
                paginationContainer.innerHTML = data.pagination;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            tableBody.style.opacity = '1';
        });
    }

    inputs.forEach(input => {
        input.addEventListener('input', debounce(fetchMembers, 500));
        if (input.tagName === 'SELECT') {
            input.addEventListener('change', fetchMembers);
        }
    });

    // Prevent default form submission on enter
    filterForm.addEventListener('submit', function(e) {
        e.preventDefault();
        fetchMembers();
    });

    // Close menu on scroll to prevent floating weirdness
    document.addEventListener('scroll', function() {
        document.getElementById('globalContextMenu').style.display = 'none';
    }, true);
</script>
@endsection
