@extends('layouts.admin')

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div class="header" style="background: none; text-align: left; padding: 0; margin-bottom: 2rem; color: var(--dark);">
        <a href="{{ route('members.index') }}" style="color: var(--text-light); text-decoration: none; font-size: 0.9rem; margin-bottom: 0.5rem; display: block;">&larr; Back to Members</a>
        <h1 style="color: var(--dark); font-size: 1.8rem;">Edit Member</h1>
        <p style="color: var(--text-light);">{{ $member->first_name }} {{ $member->last_name }} ({{ $member->digital_id }})</p>
    </div>

    <div class="card" style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);">
        @if($errors->any())
            <div class="alert alert-danger" style="background: rgba(239, 68, 68, 0.1); color: var(--danger); border: 1px solid rgba(239, 68, 68, 0.2); padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <ul style="margin: 0; padding-left: 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('members.update', $member->id) }}">
            @csrf
            @method('PUT')
            
            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem;">Personal Information</h3>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Surname</label>
                    <input type="text" name="last_name" class="form-control @error('last_name') is-invalid @enderror" value="{{ old('last_name', $member->last_name) }}" required>
                    @error('last_name') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">First Names</label>
                    <input type="text" name="first_name" class="form-control @error('first_name') is-invalid @enderror" value="{{ old('first_name', $member->first_name) }}" required>
                    @error('first_name') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Identity Number</label>
                    <input type="text" name="identity_number" class="form-control @error('identity_number') is-invalid @enderror" value="{{ old('identity_number', $member->identity_number) }}" required>
                    @error('identity_number') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Gender</label>
                    <select name="gender" class="form-control @error('gender') is-invalid @enderror" required>
                        <option value="">Select Gender</option>
                        <option value="Male" {{ old('gender', $member->gender) == 'Male' ? 'selected' : '' }}>Male</option>
                        <option value="Female" {{ old('gender', $member->gender) == 'Female' ? 'selected' : '' }}>Female</option>
                    </select>
                    @error('gender') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Monthly Wages</label>
                    <input type="number" step="0.01" name="monthly_wages" class="form-control @error('monthly_wages') is-invalid @enderror" value="{{ old('monthly_wages', $member->monthly_wages) }}" required>
                    @error('monthly_wages') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Occupation</label>
                    <input type="text" name="designation" class="form-control @error('designation') is-invalid @enderror" value="{{ old('designation', $member->designation) }}" required>
                    @error('designation') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Home Address</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Street Number</label>
                    <input type="text" name="home_address_line1" class="form-control @error('home_address_line1') is-invalid @enderror" value="{{ old('home_address_line1', $member->home_address_line1) }}" required>
                    @error('home_address_line1') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Street Name</label>
                    <input type="text" name="home_address_line2" class="form-control @error('home_address_line2') is-invalid @enderror" value="{{ old('home_address_line2', $member->home_address_line2) }}" required>
                    @error('home_address_line2') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">City</label>
                    <input type="text" name="home_city" class="form-control @error('home_city') is-invalid @enderror" value="{{ old('home_city', $member->home_city) }}" required>
                    @error('home_city') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Code</label>
                    <input type="text" name="home_code" class="form-control @error('home_code') is-invalid @enderror" value="{{ old('home_code', $member->home_code) }}" required>
                    @error('home_code') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Province</label>
                    <select name="home_province" class="form-control @error('home_province') is-invalid @enderror" required>
                        <option value="">Select Province</option>
                        @foreach(['Eastern Cape', 'Free State', 'Gauteng', 'KwaZulu-Natal', 'Limpopo', 'Mpumalanga', 'Northern Cape', 'North West', 'Western Cape'] as $prov)
                            <option value="{{ $prov }}" {{ old('home_province', $member->home_province) == $prov ? 'selected' : '' }}>{{ $prov }}</option>
                        @endforeach
                    </select>
                    @error('home_province') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Postal Address</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">PO Box</label>
                    <input type="text" name="postal_box" class="form-control @error('postal_box') is-invalid @enderror" value="{{ old('postal_box', $member->postal_box) }}" required>
                    @error('postal_box') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">City</label>
                    <input type="text" name="postal_city" class="form-control @error('postal_city') is-invalid @enderror" value="{{ old('postal_city', $member->postal_city) }}" required>
                    @error('postal_city') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Code</label>
                    <input type="text" name="postal_code" class="form-control @error('postal_code') is-invalid @enderror" value="{{ old('postal_code', $member->postal_code) }}" required>
                    @error('postal_code') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Province</label>
                    <select name="postal_province" class="form-control @error('postal_province') is-invalid @enderror" required>
                        <option value="">Select Province</option>
                        @foreach(['Eastern Cape', 'Free State', 'Gauteng', 'KwaZulu-Natal', 'Limpopo', 'Mpumalanga', 'Northern Cape', 'North West', 'Western Cape'] as $prov)
                            <option value="{{ $prov }}" {{ old('postal_province', $member->postal_province) == $prov ? 'selected' : '' }}>{{ $prov }}</option>
                        @endforeach
                    </select>
                    @error('postal_province') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Contact Details</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Telephone No</label>
                    <input type="text" name="phone" class="form-control @error('phone') is-invalid @enderror" value="{{ old('phone', $member->phone) }}" required>
                    @error('phone') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">Email (Optional)</label>
                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $member->email) }}">
                    @error('email') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label class="form-label">Recruiter's Name</label>
                <input type="text" name="recruiter_name" class="form-control @error('recruiter_name') is-invalid @enderror" value="{{ old('recruiter_name', $member->recruiter_name) }}" required>
                @error('recruiter_name') <div class="error-message">{{ $message }}</div> @enderror
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">System Status</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Membership Status</label>
                    <select name="status" class="form-control @error('status') is-invalid @enderror">
                        <option value="pending" {{ old('status', $member->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="approved" {{ old('status', $member->status) == 'approved' ? 'selected' : '' }}>Approved (Active)</option>
                        <option value="suspended" {{ old('status', $member->status) == 'suspended' ? 'selected' : '' }}>Suspended</option>
                        <option value="rejected" {{ old('status', $member->status) == 'rejected' ? 'selected' : '' }}>Rejected</option>
                    </select>
                    @error('status') <div class="error-message">{{ $message }}</div> @enderror
                    
                    @if($member->trashed())
                        <div style="margin-top: 0.5rem; color: var(--danger); font-size: 0.9rem;">
                            <strong>Note:</strong> This member is currently in the Trash. 
                            Set status to <strong>Approved</strong> or <strong>Pending</strong> to restore them.
                        </div>
                    @endif
                </div>
                <div class="form-group">
                    <label class="form-label">Dues Status</label>
                    <select name="dues_status" class="form-control @error('dues_status') is-invalid @enderror">
                        <option value="pending" {{ old('dues_status', $member->dues_status) == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="paid" {{ old('dues_status', $member->dues_status) == 'paid' ? 'selected' : '' }}>Paid</option>
                        <option value="unpaid" {{ old('dues_status', $member->dues_status) == 'unpaid' ? 'selected' : '' }}>Unpaid</option>
                    </select>
                    @error('dues_status') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="actions" style="display: flex; justify-content: space-between; margin-top: 2rem;">
                <button type="submit" class="btn btn-primary">Update Profile</button>
                
                <form action="{{ route('members.destroy', $member->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this member?');" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" style="background: crimson;">Delete Member</button>
                </form>
            </div>
        </form>
    </div>
</div>
@endsection
