@extends('layouts.admin')

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div class="header" style="background: none; text-align: left; padding: 0; margin-bottom: 2rem; color: var(--dark);">
        <a href="{{ route('members.index') }}" style="color: var(--text-light); text-decoration: none; font-size: 0.9rem; margin-bottom: 0.5rem; display: block;">&larr; Back to Members</a>
        <h1 style="color: var(--dark); font-size: 1.8rem;">Add New Member</h1>
        <p style="color: var(--text-light);">Create a new member profile</p>
    </div>

    <div class="card" style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);">
        @if($errors->any())
            <div class="alert alert-danger" style="background: rgba(239, 68, 68, 0.1); color: var(--danger); border: 1px solid rgba(239, 68, 68, 0.2); padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <ul style="margin: 0; padding-left: 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('members.store') }}">
            @csrf
            
            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem;">Personal Information</h3>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">SURNAME</label>
                    <input type="text" name="last_name" class="form-control @error('last_name') is-invalid @enderror" value="{{ old('last_name') }}" required placeholder="e.g. Doe">
                    @error('last_name') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">FIRST NAMES</label>
                    <input type="text" name="first_name" class="form-control @error('first_name') is-invalid @enderror" value="{{ old('first_name') }}" required placeholder="e.g. John">
                    @error('first_name') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">IDENTITY NUMBER</label>
                    <input type="text" name="identity_number" class="form-control @error('identity_number') is-invalid @enderror" value="{{ old('identity_number') }}" placeholder="13-digit ID" required>
                    @error('identity_number') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">GENDER</label>
                    <select name="gender" class="form-control @error('gender') is-invalid @enderror" required>
                        <option value="">Select Gender</option>
                        <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                        <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                    </select>
                    @error('gender') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">MONTHLY BASIC WAGE (R)</label>
                    <input type="number" step="0.01" name="monthly_wages" class="form-control @error('monthly_wages') is-invalid @enderror" value="{{ old('monthly_wages') }}" placeholder="0.00" required>
                    @error('monthly_wages') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">OCCUPATION</label>
                    <input type="text" name="designation" class="form-control @error('designation') is-invalid @enderror" value="{{ old('designation') }}" placeholder="Job Title">
                    @error('designation') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Home Address</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">STREET NUMBER</label>
                    <input type="text" name="home_address_line1" class="form-control @error('home_address_line1') is-invalid @enderror" value="{{ old('home_address_line1') }}" placeholder="e.g. 123" required>
                    @error('home_address_line1') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">STREET NAME</label>
                    <input type="text" name="home_address_line2" class="form-control @error('home_address_line2') is-invalid @enderror" value="{{ old('home_address_line2') }}" placeholder="e.g. Main Street" required>
                    @error('home_address_line2') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">CITY</label>
                    <input type="text" name="home_city" class="form-control @error('home_city') is-invalid @enderror" value="{{ old('home_city') }}" required>
                    @error('home_city') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">CODE</label>
                    <input type="text" name="home_code" class="form-control @error('home_code') is-invalid @enderror" value="{{ old('home_code') }}" required>
                    @error('home_code') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">PROVINCE</label>
                    <select name="home_province" class="form-control @error('home_province') is-invalid @enderror" required>
                        <option value="">Select Province</option>
                        <option value="Eastern Cape" {{ old('home_province') == 'Eastern Cape' ? 'selected' : '' }}>Eastern Cape</option>
                        <option value="Free State" {{ old('home_province') == 'Free State' ? 'selected' : '' }}>Free State</option>
                        <option value="Gauteng" {{ old('home_province') == 'Gauteng' ? 'selected' : '' }}>Gauteng</option>
                        <option value="KwaZulu-Natal" {{ old('home_province') == 'KwaZulu-Natal' ? 'selected' : '' }}>KwaZulu-Natal</option>
                        <option value="Limpopo" {{ old('home_province') == 'Limpopo' ? 'selected' : '' }}>Limpopo</option>
                        <option value="Mpumalanga" {{ old('home_province') == 'Mpumalanga' ? 'selected' : '' }}>Mpumalanga</option>
                        <option value="Northern Cape" {{ old('home_province') == 'Northern Cape' ? 'selected' : '' }}>Northern Cape</option>
                        <option value="North West" {{ old('home_province') == 'North West' ? 'selected' : '' }}>North West</option>
                        <option value="Western Cape" {{ old('home_province') == 'Western Cape' ? 'selected' : '' }}>Western Cape</option>
                    </select>
                    @error('home_province') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Postal Address</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">PO BOX NUMBER</label>
                    <input type="text" name="postal_box" class="form-control @error('postal_box') is-invalid @enderror" value="{{ old('postal_box') }}" required>
                    @error('postal_box') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">CITY</label>
                    <input type="text" name="postal_city" class="form-control @error('postal_city') is-invalid @enderror" value="{{ old('postal_city') }}" required>
                    @error('postal_city') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">CODE</label>
                    <input type="text" name="postal_code" class="form-control @error('postal_code') is-invalid @enderror" value="{{ old('postal_code') }}" required>
                    @error('postal_code') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">PROVINCE</label>
                    <select name="postal_province" class="form-control @error('postal_province') is-invalid @enderror" required>
                        <option value="">Select Province</option>
                        <option value="Eastern Cape" {{ old('postal_province') == 'Eastern Cape' ? 'selected' : '' }}>Eastern Cape</option>
                        <option value="Free State" {{ old('postal_province') == 'Free State' ? 'selected' : '' }}>Free State</option>
                        <option value="Gauteng" {{ old('postal_province') == 'Gauteng' ? 'selected' : '' }}>Gauteng</option>
                        <option value="KwaZulu-Natal" {{ old('postal_province') == 'KwaZulu-Natal' ? 'selected' : '' }}>KwaZulu-Natal</option>
                        <option value="Limpopo" {{ old('postal_province') == 'Limpopo' ? 'selected' : '' }}>Limpopo</option>
                        <option value="Mpumalanga" {{ old('postal_province') == 'Mpumalanga' ? 'selected' : '' }}>Mpumalanga</option>
                        <option value="Northern Cape" {{ old('postal_province') == 'Northern Cape' ? 'selected' : '' }}>Northern Cape</option>
                        <option value="North West" {{ old('postal_province') == 'North West' ? 'selected' : '' }}>North West</option>
                        <option value="Western Cape" {{ old('postal_province') == 'Western Cape' ? 'selected' : '' }}>Western Cape</option>
                    </select>
                    @error('postal_province') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Contact Details</h3>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">TELEPHONE NO</label>
                    <input type="text" name="phone" class="form-control @error('phone') is-invalid @enderror" value="{{ old('phone') }}" required>
                    @error('phone') <div class="error-message">{{ $message }}</div> @enderror
                </div>
                <div class="form-group">
                    <label class="form-label">EMAIL ADDRESS (Optional)</label>
                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}">
                    @error('email') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label class="form-label">RECRUITER'S NAME</label>
                <input type="text" name="recruiter_name" class="form-control @error('recruiter_name') is-invalid @enderror" value="{{ old('recruiter_name') }}" required>
                @error('recruiter_name') <div class="error-message">{{ $message }}</div> @enderror
            </div>

            <h3 style="margin-bottom: 1.5rem; font-size: 1.1rem; color: var(--dark); border-bottom: 1px solid #f1f5f9; padding-bottom: 0.5rem; margin-top: 2rem;">Workplace</h3>

            <div style="display: grid; grid-template-columns: 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div class="form-group">
                    <label class="form-label">Workplace Name</label>
                    <input type="text" name="workplace" class="form-control @error('workplace') is-invalid @enderror" value="{{ old('workplace') }}" required>
                    @error('workplace') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <!-- Internal Status (Auto-approved for Admin creation) -->
            <input type="hidden" name="status" value="approved">
            <input type="hidden" name="dues_status" value="pending">

            <!-- Acknowledgement Section -->
            <div style="background: #f8fafc; padding: 1.5rem; border-radius: 12px; border: 1px solid #e2e8f0; margin-top: 2rem;">
                <h4 style="color: var(--dark); margin-bottom: 1rem; font-size: 1rem;">Acknowledgement & Authorisation</h4>
                
                <p style="font-size: 0.9rem; color: var(--text); line-height: 1.6; margin-bottom: 1rem;">
                    I HEREBY AUTHORISE MY EMPLOYER TO DEDUCT 1.5% OF MY BASIC SALARY OR R60.00, WHICHEVER IS THE GREATER.
                </p>
                <p style="font-size: 0.9rem; color: var(--text); line-height: 1.6; margin-bottom: 1rem;">
                    I the undersigned having acquainted myself with the rules of the Union’s Constitution agree to abide by the Constitution and any amendments thereto.
                </p>
                
                <div class="form-group" style="margin-bottom: 1rem;">
                    <label class="form-label" style="font-weight: normal;">Upon acceptance of my membership, I hereby cancel my membership with:</label>
                    <input type="text" name="previous_union" class="form-control" value="{{ old('previous_union') }}" placeholder="Name of previous Union (if applicable)">
                </div>

                <div class="form-group" style="margin-top: 1.5rem;">
                    <label class="form-label">Date</label>
                    <input type="date" name="agreement_date" class="form-control @error('agreement_date') is-invalid @enderror" style="width: 200px;" value="{{ old('agreement_date', date('Y-m-d')) }}" required>
                    @error('agreement_date') <div class="error-message">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="actions" style="margin-top: 2rem;">
                <button type="submit" class="btn btn-primary" style="width: 100%; justify-content: center; padding: 1rem;">Create Member Profile</button>
            </div>
        </form>
    </div>
</div>
@endsection
