<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'MTWU Admin')</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #4f46e5;
            --primary-hover: #4338ca;
            --secondary: #ec4899;
            --dark: #0f172a;
            --dark-light: #1e293b;
            --light: #f8fafc;
            --text: #334155;
            --text-light: #94a3b8;
            --success: #10b981;
            --danger: #ef4444;
            --border: #e2e8f0;
            --glass: rgba(255, 255, 255, 0.9);
            --sidebar-width: 280px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Outfit', sans-serif;
            background: var(--light);
            color: var(--text);
            display: flex;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Sidebar Styling */
        .sidebar {
            width: var(--sidebar-width);
            background: linear-gradient(180deg, var(--dark) 0%, #1e1b4b 100%);
            color: white;
            position: fixed;
            height: 100vh;
            display: flex;
            flex-direction: column;
            box-shadow: 4px 0 24px rgba(0,0,0,0.1);
            z-index: 100;
        }

        .brand {
            padding: 2rem;
            font-size: 1.5rem;
            font-weight: 700;
            background: rgba(255,255,255,0.03);
            border-bottom: 1px solid rgba(255,255,255,0.05);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .brand-icon {
            width: 32px;
            height: 32px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .nav {
            flex: 1;
            padding: 1.5rem 1rem;
            overflow-y: auto;
        }

        .nav-category {
            font-size: 0.75rem;
            text-transform: uppercase;
            color: rgba(255,255,255,0.4);
            font-weight: 600;
            letter-spacing: 0.05em;
            margin-bottom: 0.75rem;
            padding-left: 1rem;
            margin-top: 1rem;
        }
        
        .nav-category:first-of-type {
            margin-top: 0;
        }

        .nav-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.85rem 1rem;
            color: #94a3b8;
            text-decoration: none;
            border-radius: 12px;
            margin-bottom: 0.25rem;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            font-weight: 500;
            font-size: 0.95rem;
        }

        .nav-item:hover {
            background: rgba(255,255,255,0.05);
            color: white;
            transform: translateX(4px);
        }

        .nav-item.active {
            background: linear-gradient(90deg, rgba(79, 70, 229, 0.15), rgba(79, 70, 229, 0.05));
            color: white;
            border-left: 3px solid var(--primary);
            border-radius: 0 12px 12px 0; /* Only round right side */
            margin-left: -1rem; /* Extend to edge */
            padding-left: calc(1rem + 3px); /* Compensate for border */
        }
        
        .nav-item svg {
            width: 20px;
            height: 20px;
            opacity: 0.7;
            transition: 0.2s;
        }
        
        .nav-item:hover svg, .nav-item.active svg {
            opacity: 1;
            color: var(--primary);
        }

        .nav-sub-menu {
            display: none;
            padding-left: 0.5rem;
            margin-bottom: 0.5rem;
            background: rgba(0,0,0,0.1);
            border-radius: 12px;
            margin-top: -0.25rem;
            overflow: hidden;
        }
        
        .nav-sub-menu.open {
            display: block;
        }
        
        .nav-sub-item {
            display: flex;
            align-items: center;
            padding: 0.6rem 1rem 0.6rem 2.5rem;
            color: #94a3b8;
            text-decoration: none;
            font-size: 0.85rem;
            transition: all 0.2s;
            position: relative;
        }
        
        .nav-sub-item:hover {
            color: white;
            padding-left: 2.75rem;
        }
        
        .nav-sub-item::before {
            content: '';
            position: absolute;
            left: 1.5rem;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 4px;
            background: rgba(255,255,255,0.3);
            border-radius: 50%;
        }
        
        .nav-sub-item:hover::before {
            background: var(--primary);
        }
        
        .nav-group .nav-item {
            cursor: pointer;
            justify-content: flex-start;
        }
        
        .chevron {
            margin-left: auto;
            transition: transform 0.2s;
            opacity: 0.5;
            width: 16px !important;
            height: 16px !important;
        }
        
        .nav-group.active .chevron {
            transform: rotate(180deg);
        }

        /* User Profile in Sidebar */
        .user-profile {
            padding: 1.5rem;
            border-top: 1px solid rgba(255,255,255,0.05);
            background: rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .avatar {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: white;
            font-size: 1.1rem;
            border: 2px solid rgba(255,255,255,0.1);
        }
        
        .user-info {
            flex: 1;
        }
        
        .user-name {
            font-weight: 600;
            font-size: 0.95rem;
            color: white;
        }
        
        .user-role {
            font-size: 0.75rem;
            color: rgba(255,255,255,0.5);
        }

        /* Main Content Styling */
        .main-content {
            margin-left: var(--sidebar-width);
            flex: 1;
            padding: 2.5rem;
            background: #f1f5f9;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            margin-bottom: 2.5rem;
        }
        
        .header h1 {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 0.25rem;
        }
        
        .header p {
            color: var(--text-light);
            font-size: 0.95rem;
        }

        /* UI Components reused in views */
        .card {
            background: white;
            padding: 1.75rem;
            border-radius: 16px;
            box-shadow: 0 4px 20px -2px rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(255,255,255,0.5);
            position: relative;
            overflow: hidden;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        .card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            opacity: 0;
            transition: 0.2s;
        }
        
        .card:hover::before {
            opacity: 1;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        
        .card-icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        
        .card h3 {
            font-size: 0.9rem;
            color: #64748b;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .card .value {
            font-size: 2.2rem;
            font-weight: 700;
            color: var(--dark);
            letter-spacing: -0.02em;
        }
        
        .trend {
            display: flex;
            align-items: center;
            gap: 0.25rem;
            font-size: 0.85rem;
            margin-top: 0.75rem;
            padding-top: 0.75rem;
            border-top: 1px solid #f1f5f9;
        }
        
        .trend.up { color: var(--success); }
        .trend.down { color: var(--danger); }
        
        /* Icons */
        .icon-members { background: rgba(79, 70, 229, 0.1); color: var(--primary); }
        .icon-grievances { background: rgba(239, 68, 68, 0.1); color: var(--danger); }
        .icon-events { background: rgba(236, 72, 153, 0.1); color: var(--secondary); }
        .icon-messages { background: rgba(16, 185, 129, 0.1); color: var(--success); }
        .icon-devices { background: rgba(59, 130, 246, 0.1); color: #3b82f6; }

        .btn {
            padding: 0.6rem 1.2rem;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
            border: none;
            font-size: 0.9rem;
            transition: all 0.2s;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }
        
        .btn-primary:hover {
            background: var(--primary-hover);
        }
        
        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .form-control {
            width: 100%;
            padding: 0.6rem 1rem;
            border: 1px solid var(--border);
            border-radius: 8px;
            font-family: inherit;
        }
        
        .form-control.is-invalid {
            border-color: var(--danger);
            background-color: rgba(239, 68, 68, 0.02);
        }
        
        .error-message {
            color: var(--danger);
            font-size: 0.8rem;
            margin-top: 0.25rem;
            font-weight: 500;
        }
        
        .form-label {
            display: block;
            margin-bottom: 0.4rem;
            font-weight: 500;
            color: var(--dark-light);
            font-size: 0.9rem;
        }
        
        .badge {
            padding: 0.25rem 0.6rem;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .badge-success { background: rgba(16, 185, 129, 0.1); color: var(--success); }
        .badge-danger { background: rgba(239, 68, 68, 0.1); color: var(--danger); }
        
        .alert { padding: 1rem; border-radius: 8px; margin-bottom: 1rem; }
        .alert-success { background: rgba(16, 185, 129, 0.1); color: #065f46; border: 1px solid rgba(16, 185, 129, 0.2); }

        /* Card Grid for Dashboard */
        .card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <a href="{{ route('dashboard') }}" class="brand" style="text-decoration: none; color: white;">
            <div class="brand-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"></path></svg>
            </div>
            <span>MTWU Admin</span>
        </a>
        <nav class="nav">
            <div class="nav-category">Main Menu</div>
            
            <a href="{{ route('dashboard') }}" class="nav-item {{ Route::is('dashboard') ? 'active' : '' }}">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="7" height="7"></rect><rect x="14" y="3" width="7" height="7"></rect><rect x="14" y="14" width="7" height="7"></rect><rect x="3" y="14" width="7" height="7"></rect></svg>
                Dashboard
            </a>
            <div class="nav-group {{ Route::is('members.*') ? 'active' : '' }}">
                <div class="nav-item {{ Route::is('members.*') ? 'active' : '' }}" onclick="toggleMenu(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                    Membership
                    <svg class="chevron" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                </div>
                <div class="nav-sub-menu {{ Route::is('members.*') ? 'open' : '' }}">
                    <a href="{{ route('members.index') }}" class="nav-sub-item">Manage Members</a>
                </div>
            </div>
            <div class="nav-group {{ Route::is('admin.messages.*') ? 'active' : '' }}">
                <div class="nav-item {{ Route::is('admin.messages.*') ? 'active' : '' }}" onclick="toggleMenu(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path></svg>
                    Communication
                    <svg class="chevron" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                </div>
                <div class="nav-sub-menu {{ Route::is('admin.messages.*') ? 'open' : '' }}">
                    <a href="{{ route('admin.messages.index') }}" class="nav-sub-item">Messages</a>
                    <a href="{{ route('admin.messages.archived') }}" class="nav-sub-item">Archived Messages</a>
                </div>
            </div>
            <a href="{{ route('admin.events.index') }}" class="nav-item {{ Route::is('admin.events.*') ? 'active' : '' }}">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
                Events
            </a>
            
            <div class="nav-category">Management</div>
            
            <div class="nav-group {{ Route::is('admin.cases.*') ? 'active' : '' }}">
                <div class="nav-item {{ Route::is('admin.cases.*') ? 'active' : '' }}" onclick="toggleMenu(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                    Cases
                    <svg class="chevron" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                </div>
                <div class="nav-sub-menu {{ Route::is('admin.cases.*') ? 'open' : '' }}">
                    <a href="{{ route('admin.cases.index') }}" class="nav-sub-item">Active Cases</a>
                    <a href="{{ route('admin.cases.archived') }}" class="nav-sub-item">Archived Cases</a>
                </div>
            </div>
            <div class="nav-group {{ Route::is('admin.finance.*') ? 'active' : '' }}">
                <div class="nav-item {{ Route::is('admin.finance.*') ? 'active' : '' }}" onclick="toggleMenu(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="1" x2="12" y2="23"></line><path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path></svg>
                    Finance
                    <svg class="chevron" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                </div>
                <div class="nav-sub-menu {{ Route::is('admin.finance.*') ? 'open' : '' }}">
                    <a href="{{ route('admin.finance.contributions') }}" class="nav-sub-item">Contributions & Subscriptions</a>
                    <a href="{{ route('admin.finance.records') }}" class="nav-sub-item">Payment Records</a>
                    <a href="{{ route('admin.finance.receipts') }}" class="nav-sub-item">Receipts & Proof of Payment</a>
                </div>
            </div>
            <div class="nav-group {{ Route::is('admin.resources.*') ? 'active' : '' }}">
                <div class="nav-item {{ Route::is('admin.resources.*') ? 'active' : '' }}" onclick="toggleMenu(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path><polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline><line x1="12" y1="22.08" x2="12" y2="12"></line></svg>
                    Resources
                    <svg class="chevron" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                </div>
                <div class="nav-sub-menu {{ Route::is('admin.resources.*') ? 'open' : '' }}">
                    <a href="{{ route('admin.resources.press.index') }}" class="nav-sub-item">Press</a>
                    <a href="{{ route('admin.resources.achievements') }}" class="nav-sub-item">Achievements</a>
                    <a href="{{ route('admin.resources.gallery') }}" class="nav-sub-item">Gallery</a>
                    <a href="{{ route('admin.resources.funeral-plan') }}" class="nav-sub-item">Funeral Plan</a>
                    <a href="{{ route('admin.resources.documents.index') }}" class="nav-sub-item">Documents</a>
                </div>
            </div>
            
            <div class="nav-category">System</div>
            
            <a href="#" class="nav-item">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
                News
            </a>
            <a href="{{ route('admin.settings.index') }}" class="nav-item {{ Route::is('admin.settings.*') ? 'active' : '' }}">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="3"></circle><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path></svg>
                Settings
            </a>

            <a href="{{ route('users.index') }}" class="nav-item {{ Route::is('users.*') ? 'active' : '' }}">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                Users
            </a>
        </nav>
        
        <div class="user-profile">
            <div class="avatar">
                {{ substr(Auth::user()->name ?? 'A', 0, 1) }}
            </div>
            <div class="user-info">
                <div class="user-name">{{ Auth::user()->name ?? 'Admin' }}</div>
                <div class="user-role">Super Admin</div>
            </div>
            
            <form method="POST" action="{{ route('logout') }}" style="margin-left: auto;">
                @csrf
                <button type="submit" title="Logout" style="background: none; border: none; cursor: pointer; color: rgba(255,255,255,0.6); display: flex; align-items: center; justify-content: center; padding: 0.5rem; border-radius: 8px; transition: 0.2s;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" y1="12" x2="9" y2="12"></line></svg>
                </button>
            </form>
        </div>
    </div>

    <div class="main-content">
        @yield('content')
    </div>
    <script>
        function toggleMenu(element) {
            const group = element.parentElement;
            const subMenu = group.querySelector('.nav-sub-menu');
            
            group.classList.toggle('active');
            subMenu.classList.toggle('open');
        }
    </script>
</body>
</html>
