@extends('installer.layout')

@section('content')
    <h3 style="margin-bottom: 1.5rem;">Server Requirements</h3>

    <ul class="status-list">
        <!-- PHP Version -->
        <li class="status-item {{ $results['php']['supported'] ? 'success' : 'error' }}">
            <span style="font-weight: 500;">PHP Version >= {{ $results['php']['min'] }}</span>
            <span class="badge {{ $results['php']['supported'] ? 'badge-success' : 'badge-danger' }}">
                Current: {{ $results['php']['version'] }}
            </span>
        </li>

        <!-- Extensions -->
        @foreach($results['requirements'] as $extension => $enabled)
        <li class="status-item {{ $enabled ? 'success' : 'error' }}">
            <span style="text-transform: capitalize;">{{ $extension }}</span>
            <span class="badge {{ $enabled ? 'badge-success' : 'badge-danger' }}">
                {{ $enabled ? 'Enabled' : 'Missing' }}
            </span>
        </li>
        @endforeach
    </ul>

    <div class="actions">
        @if($check)
            <a href="{{ route('installer.permissions') }}" class="btn btn-primary">
                Check Permissions
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                    <polyline points="12 5 19 12 12 19"></polyline>
                </svg>
            </a>
        @else
            <a href="{{ route('installer.requirements') }}" class="btn btn-danger">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M23 4v6h-6"></path>
                    <path d="M20.49 15a9 9 0 1 1-2.12-9.36L23 10"></path>
                </svg>
                Refresh
            </a>
        @endif
    </div>
@endsection
