@extends('installer.layout')

@section('content')
    <h3 style="margin-bottom: 1.5rem;">File Permissions</h3>

    <ul class="status-list">
        @foreach($results['permissions'] as $permission)
        <li class="status-item {{ $permission['isSet'] ? 'success' : 'error' }}">
            <span>{{ $permission['folder'] }}</span>
            <div style="display: flex; gap: 1rem; align-items: center;">
                <span style="font-size: 0.85rem; color: var(--text-light);">Required: {{ $permission['permission'] }}</span>
                <span class="badge {{ $permission['isSet'] ? 'badge-success' : 'badge-danger' }}">
                    {{ $permission['isSet'] ? 'Writable' : 'Not Writable' }}
                </span>
            </div>
        </li>
        @endforeach
    </ul>

    <div class="actions">
        @if($check)
            <a href="{{ route('installer.environment') }}" class="btn btn-primary">
                Configure Database
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                    <polyline points="12 5 19 12 12 19"></polyline>
                </svg>
            </a>
        @else
            <a href="{{ route('installer.permissions') }}" class="btn btn-danger">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M23 4v6h-6"></path>
                    <path d="M20.49 15a9 9 0 1 1-2.12-9.36L23 10"></path>
                </svg>
                Refresh
            </a>
        @endif
    </div>
@endsection
