<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Wizard | MTWU</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #4f46e5;
            --primary-hover: #4338ca;
            --secondary: #ec4899;
            --dark: #0f172a;
            --dark-light: #1e293b;
            --light: #f8fafc;
            --text: #334155;
            --text-light: #94a3b8;
            --success: #10b981;
            --danger: #ef4444;
            --border: #e2e8f0;
            --glass: rgba(255, 255, 255, 0.9);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Outfit', sans-serif;
            background: linear-gradient(135deg, var(--dark) 0%, #1e1b4b 100%);
            color: var(--text);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }

        .installer-container {
            background: var(--glass);
            width: 100%;
            max-width: 800px;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
            overflow: hidden;
            display: flex;
            flex-direction: column;
            backdrop-filter: blur(10px);
            animation: fadeIn 0.6s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .header {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            padding: 2rem;
            color: white;
            text-align: center;
        }

        .header h1 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .header p {
            opacity: 0.9;
            font-size: 0.95rem;
        }

        .progress-bar {
            display: flex;
            background: var(--dark-light);
            padding: 1rem 2rem;
            justify-content: space-between;
        }

        .step {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--text-light);
            font-size: 0.9rem;
            position: relative;
        }

        .step.active {
            color: white;
            font-weight: 600;
        }

        .step.completed {
            color: var(--success);
        }

        .step-icon {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            border: 2px solid var(--text-light);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.75rem;
        }

        .step.active .step-icon {
            border-color: var(--primary);
            background: var(--primary);
            color: white;
        }

        .step.completed .step-icon {
            border-color: var(--success);
            background: var(--success);
            color: var(--dark);
        }

        .content {
            padding: 2.5rem;
            background: white;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.2s;
            cursor: pointer;
            border: none;
            font-size: 0.95rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
            box-shadow: 0 4px 12px rgba(79, 70, 229, 0.3);
        }

        .btn-primary:hover {
            background: var(--primary-hover);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(79, 70, 229, 0.4);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }
        
        .actions {
            margin-top: 2rem;
            display: flex;
            justify-content: flex-end;
            gap: 1rem;
            border-top: 1px solid var(--border);
            padding-top: 1.5rem;
        }

        /* Form Styles */
        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: var(--dark-light);
            font-size: 0.9rem;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 2px solid var(--border);
            border-radius: 10px;
            font-family: inherit;
            font-size: 0.95rem;
            transition: all 0.2s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(79, 70, 229, 0.1);
        }

        /* Status List */
        .status-list {
            list-style: none;
            border: 1px solid var(--border);
            border-radius: 12px;
            overflow: hidden;
        }

        .status-item {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.95rem;
        }

        .status-item:last-child {
            border-bottom: none;
        }

        .status-item.success {
            background: rgba(16, 185, 129, 0.05);
        }

        .status-item.error {
            background: rgba(239, 68, 68, 0.05);
        }

        .badge {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .badge-success {
            background: rgba(16, 185, 129, 0.15);
            color: var(--success);
        }

        .badge-danger {
            background: rgba(239, 68, 68, 0.15);
            color: var(--danger);
        }

        /* Alert */
        .alert {
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-error {
            background: rgba(239, 68, 68, 0.1);
            color: #b91c1c;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }
        
        .alert-success {
            background: rgba(16, 185, 129, 0.1);
            color: #047857;
            border: 1px solid rgba(16, 185, 129, 0.2);
        }

    </style>
</head>
<body>
    <div class="installer-container">
        <div class="header">
            <h1>MTWU Installation</h1>
            <p>Admin Panel Setup Wizard</p>
        </div>
        
        <div class="progress-bar">
            <div class="step {{ Route::currentRouteName() == 'installer.welcome' ? 'active' : (Route::currentRouteName() != 'installer.welcome' ? 'completed' : '') }}">
                <div class="step-icon">1</div>
                <span>Welcome</span>
            </div>
            <div class="step {{ Route::currentRouteName() == 'installer.requirements' ? 'active' : (in_array(Route::currentRouteName(), ['installer.permissions', 'installer.environment', 'installer.overview', 'installer.finish']) ? 'completed' : '') }}">
                <div class="step-icon">2</div>
                <span>Requirements</span>
            </div>
            <div class="step {{ Route::currentRouteName() == 'installer.permissions' ? 'active' : (in_array(Route::currentRouteName(), ['installer.environment', 'installer.overview', 'installer.finish']) ? 'completed' : '') }}">
                <div class="step-icon">3</div>
                <span>Permissions</span>
            </div>
            <div class="step {{ Route::currentRouteName() == 'installer.environment' ? 'active' : (in_array(Route::currentRouteName(), ['installer.overview', 'installer.admin', 'installer.finish']) ? 'completed' : '') }}">
                <div class="step-icon">4</div>
                <span>Database</span>
            </div>
            <div class="step {{ Route::currentRouteName() == 'installer.overview' ? 'active' : (in_array(Route::currentRouteName(), ['installer.admin', 'installer.finish']) ? 'completed' : '') }}">
                <div class="step-icon">5</div>
                <span>Install</span>
            </div>
            <div class="step {{ Route::currentRouteName() == 'installer.admin' ? 'active' : (Route::currentRouteName() == 'installer.finish' ? 'completed' : '') }}">
                <div class="step-icon">6</div>
                <span>Admin</span>
            </div>
        </div>

        <div class="content">
            @if(session('message'))
                <div class="alert alert-success">
                    {{ session('message') }}
                </div>
            @endif
            
            @yield('content')
        </div>
    </div>
</body>
</html>
