@extends('installer.layout')

@section('content')
    <h3 style="margin-bottom: 1.5rem;">Database Configuration</h3>

    @if($errors->any())
        <div class="alert alert-error">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            <div>
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        </div>
    @endif

    <form method="post" action="{{ route('installer.environmentSave') }}">
        @csrf
        <div class="form-group">
            <label class="form-label">App Name</label>
            <input type="text" name="app_name" class="form-control" value="{{ old('app_name', 'MTWU Admin') }}" required>
        </div>

        <div class="form-group">
            <label class="form-label">App URL</label>
            <input type="url" name="app_url" class="form-control" value="{{ old('app_url', request()->root()) }}" required>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
            <div class="form-group">
                <label class="form-label">Database Connection</label>
                <select name="database_connection" class="form-control">
                    <option value="mysql" selected>MySQL</option>
                    <option value="sqlite">SQLite</option>
                    <option value="pgsql">PostgreSQL</option>
                    <option value="sqlsrv">SQL Server</option>
                </select>
            </div>
            <div class="form-group">
                <label class="form-label">Database Port</label>
                <input type="number" name="database_port" class="form-control" value="{{ old('database_port', '3306') }}" required>
            </div>
        </div>

        <div class="form-group">
            <label class="form-label">Database Host</label>
            <input type="text" name="database_host" class="form-control" value="{{ old('database_host', '127.0.0.1') }}" required>
        </div>

        <div class="form-group">
            <label class="form-label">Database Name</label>
            <input type="text" name="database_name" class="form-control" value="{{ old('database_name', 'mtwu_db') }}" required>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
            <div class="form-group">
                <label class="form-label">Database Username</label>
                <input type="text" name="database_username" class="form-control" value="{{ old('database_username', 'root') }}" required>
            </div>
            <div class="form-group">
                <label class="form-label">Database Password</label>
                <input type="password" name="database_password" class="form-control" value="{{ old('database_password') }}">
            </div>
        </div>

        <div class="actions">
            <button type="submit" class="btn btn-primary">
                Save & Continue
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                    <polyline points="12 5 19 12 12 19"></polyline>
                </svg>
            </button>
        </div>
    </form>
@endsection
