@extends('layouts.admin')

@section('title', 'Dashboard | MTWU Admin')

@section('content')
    <div class="header">
        <div>
            <h1>Dashboard Overview</h1>
            <p>Welcome back, here's what's happening today.</p>
        </div>
        <div class="date" style="font-weight: 500; background: white; padding: 0.5rem 1rem; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); color: var(--text);">
            {{ date('l, F j, Y') }}
        </div>
    </div>

    <div class="card-grid" style="grid-template-columns: repeat(3, 1fr);">
        <div class="card">
            <div class="card-header">
                <div>
                    <h3>Messages</h3>
                    <div class="value">{{ $totalMessages }}</div>
                </div>
                <div class="card-icon icon-messages">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                </div>
            </div>
            <div class="trend up">
                    <span>{{ $unreadMessages }} unread</span>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div>
                    <h3>Total Members</h3>
                    <div class="value">{{ number_format($totalMembers) }}</div>
                </div>
                <div class="card-icon icon-members">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                </div>
            </div>
            <div class="trend up">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline><polyline points="17 6 23 6 23 12"></polyline></svg>
                <span>+{{ $newMembersCount }} last 30 days</span>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div>
                    <h3>Active Cases</h3>
                    <div class="value">{{ $activeCases }}</div>
                </div>
                <div class="card-icon icon-grievances">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>
                </div>
            </div>
            <div class="trend down">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="23 18 13.5 8.5 8.5 13.5 1 6"></polyline><polyline points="17 18 23 18 23 12"></polyline></svg>
                <span>Active Cases</span>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div>
                    <h3>Upcoming Events</h3>
                    <div class="value">{{ $upcomingEvents }}</div>
                </div>
                <div class="card-icon icon-events">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
                </div>
            </div>
            <div class="trend">
                <span>Next: {{ $nextEvent ? $nextEvent->title : 'None' }} {{ $nextEvent ? '(' . $nextEvent->start_time->diffForHumans() . ')' : '' }}</span>
            </div>
        </div>

        <!-- Active Devices Card -->
        <div class="card">
            <div class="card-header">
                <div>
                    <h3>Active Devices</h3>
                    <div class="value">0</div>
                </div>
                <div class="card-icon icon-devices">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="5" y="2" width="14" height="20" rx="2" ry="2"></rect><line x1="12" y1="18" x2="12.01" y2="18"></line></svg>
                </div>
            </div>
            <div class="trend">
                <span>Mobile App Pending</span>
            </div>
        </div>
    </div>
@endsection
