@extends('layouts.admin')

@section('title', 'Global Settings | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1 style="margin: 0;">Global Settings</h1>
        <p>Manage system-wide configurations and preferences.</p>
    </div>
    <a href="{{ route('admin.organization.index') }}" class="btn btn-primary" style="display: flex; align-items: center; gap: 0.5rem;">
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="7" height="7"></rect><rect x="14" y="3" width="7" height="7"></rect><rect x="14" y="14" width="7" height="7"></rect><rect x="3" y="14" width="7" height="7"></rect></svg>
        Organization Master Data
    </a>
</div>

@if(session('success'))
<div class="alert alert-success">
    {{ session('success') }}
</div>
@endif

<form action="{{ route('admin.settings.update') }}" method="POST">
    @csrf
    @method('PUT')

    @foreach($settings as $group => $groupSettings)
    <div class="card" style="margin-bottom: 2rem;">
        <div class="card-header" style="border-bottom: 1px solid #f1f5f9; padding-bottom: 1rem; margin-bottom: 1.5rem;">
            <h3 style="text-transform: capitalize; color: #4f46e5; font-size: 1.1rem; margin: 0;">
                {{ $group }} Settings
            </h3>
        </div>

        @foreach($groupSettings as $setting)
        <div style="margin-bottom: 1.5rem;">
            <label class="form-label" style="display: flex; justify-content: space-between;">
                <span>{{ str_replace('_', ' ', ucfirst($setting->key)) }}</span>
                @if($setting->type === 'boolean')
                <div class="toggle-switch">
                    <input type="checkbox" name="{{ $setting->key }}" value="1" {{ $setting->value ? 'checked' : '' }} id="setting_{{ $setting->key }}" style="width: 16px; height: 16px; accent-color: #4f46e5;">
                </div>
                @endif
            </label>
            
            @if($setting->type !== 'boolean')
                @if($setting->type === 'string' || $setting->type === 'integer')
                    <input type="{{ $setting->type === 'integer' ? 'number' : 'text' }}" 
                           name="{{ $setting->key }}" 
                           class="form-control" 
                           value="{{ $setting->value }}"
                           placeholder="{{ $setting->description }}">
                @elseif($setting->type === 'text' || $setting->type === 'json')
                    <textarea name="{{ $setting->key }}" class="form-control" rows="3">{{ $setting->value }}</textarea>
                @endif
            @endif

            @if($setting->description && $setting->type !== 'boolean')
            <div style="font-size: 0.8rem; color: #94a3b8; margin-top: 0.25rem;">
                {{ $setting->description }}
            </div>
            @elseif($setting->description && $setting->type === 'boolean')
             <div style="font-size: 0.8rem; color: #94a3b8; margin-top: 0.25rem;">
                {{ $setting->description }}
            </div>
            @endif
        </div>
        @endforeach
    </div>
    @endforeach

    <div style="display: flex; justify-content: flex-end;">
        <button type="submit" class="btn btn-primary">Save Changes</button>
    </div>
</form>
@endsection
