@extends('layouts.admin')

@section('title', 'Press Releases')

@section('content')
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Press Releases</h1>
        <a href="{{ route('admin.resources.press.create') }}" class="btn btn-primary">Create Press Release</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Visibility</th>
                    <th style="padding: 1rem;">Published Date</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($releases as $release)
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: bold;">{{ $release->title }}</div>
                            @if($release->is_featured)
                                <span class="badge" style="background: #fef08a; color: #854d0e; font-size: 0.75rem; padding: 2px 6px; border-radius: 4px;">Featured</span>
                            @endif
                        </td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="
                                padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8rem;
                                background: {{ $release->status === 'published' ? '#dcfce7' : '#f3f4f6' }};
                                color: {{ $release->status === 'published' ? '#16a34a' : '#4b5563' }};
                            ">
                                {{ ucfirst($release->status) }}
                            </span>
                        </td>
                        <td style="padding: 1rem;">{{ ucfirst($release->visibility) }}</td>
                        <td style="padding: 1rem;">
                            {{ $release->published_at ? $release->published_at->format('M d, Y') : '-' }}
                        </td>
                        <td style="padding: 1rem;">
                            <a href="{{ route('admin.resources.press.edit', $release->id) }}" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Edit</a>
                            <form action="{{ route('admin.resources.press.destroy', $release->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Delete this release?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #ef4444; color: white;">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No press releases found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            {{ $releases->links() }}
        </div>
    </div>
@endsection
