@extends('layouts.admin')

@section('title', 'Edit Press Release')

@section('content')
    <div class="header">
        <h1>Edit Press Release</h1>
    </div>

    <div class="card" style="max-width: 800px;">
        <form action="{{ route('admin.resources.press.update', $pressRelease->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" required value="{{ $pressRelease->title }}">
            </div>

            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Body</label>
                <!-- Container for Quill with initial content -->
                <div id="editor-container" style="height: 400px; background: white;">{!! $pressRelease->body !!}</div>
                <!-- Hidden input to store content -->
                <input type="hidden" name="body" id="bodyInput" value="{{ $pressRelease->body }}">
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control">
                        <option value="draft" {{ $pressRelease->status == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="published" {{ $pressRelease->status == 'published' ? 'selected' : '' }}>Published</option>
                    </select>
                </div>
                <div>
                    <label class="form-label">Visibility</label>
                    <select name="visibility" class="form-control">
                        <option value="public" {{ $pressRelease->visibility == 'public' ? 'selected' : '' }}>Public</option>
                        <option value="members" {{ $pressRelease->visibility == 'members' ? 'selected' : '' }}>Members Only</option>
                    </select>
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <label class="form-label">Publish Date</label>
                    <input type="datetime-local" name="published_at" class="form-control" value="{{ $pressRelease->published_at ? $pressRelease->published_at->format('Y-m-d\TH:i') : '' }}">
                </div>
                <div style="display: flex; align-items: center; padding-top: 1.5rem;">
                     <input type="checkbox" name="is_featured" id="is_featured" value="1" {{ $pressRelease->is_featured ? 'checked' : '' }}>
                     <label for="is_featured" style="margin-left: 0.5rem;">Feature this Statement</label>
                </div>
            </div>

            @if($pressRelease->attachments->count() > 0)
                <div style="margin-bottom: 1rem;">
                    <label class="form-label">Current Attachments</label>
                    <ul style="list-style: none; padding: 0;">
                        @foreach($pressRelease->attachments as $file)
                            <li style="background: #f9f9f9; padding: 0.5rem; margin-bottom: 0.5rem; border: 1px solid #eee; display: flex; justify-content: space-between;">
                                <span>{{ $file->file_name }}</span>
                                <span style="font-size: 0.8rem; color: #666;">({{ number_format($file->file_size / 1024, 1) }} KB)</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div style="margin-bottom: 1rem; border: 1px dashed #ccc; padding: 1rem; border-radius: 4px;">
                <label class="form-label">Add New Attachments</label>
                <input type="file" name="attachments[]" class="form-control" multiple>
            </div>

            <div style="text-align: right; margin-top: 2rem;">
                <a href="{{ route('admin.resources.press.index') }}" class="btn" style="background: #ccc; margin-right: 1rem; text-decoration: none; color: black;">Cancel</a>
                <button type="submit" class="btn btn-primary">Update Release</button>
            </div>
        </form>
    </div>

    <!-- Quill Styles and Script -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        var quill = new Quill('#editor-container', {
            theme: 'snow',
            placeholder: 'Write the press release content here...',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    ['blockquote', 'code-block'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    [{ 'script': 'sub'}, { 'script': 'super' }],
                    [{ 'indent': '-1'}, { 'indent': '+1' }],
                    [{ 'direction': 'rtl' }],
                    [{ 'size': ['small', false, 'large', 'huge'] }],
                    [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                    [{ 'color': [] }, { 'background': [] }],
                    [{ 'font': [] }],
                    [{ 'align': [] }],
                    ['link', 'image', 'video'],
                    ['clean']
                ]
            }
        });

        document.querySelector('form').onsubmit = function() {
            var body = document.querySelector('input[name=body]');
            body.value = quill.root.innerHTML;
            
            if (quill.getText().trim().length === 0) {
                alert('Please enter a body for the press release.');
                return false;
            }
        };
    </script>
@endsection
