@extends('layouts.admin')

@section('title', 'Create Press Release')

@section('content')
    <div class="header">
        <h1>Create Press Release</h1>
    </div>

    <div class="card" style="max-width: 800px;">
        <form action="{{ route('admin.resources.press.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" required placeholder="Enter title...">
            </div>

            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Body</label>
                <!-- Container for Quill -->
                <div id="editor-container" style="height: 400px; background: white;"></div>
                <!-- Hidden input to store content -->
                <input type="hidden" name="body" id="bodyInput">
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control">
                        <option value="draft">Draft</option>
                        <option value="published">Published</option>
                    </select>
                </div>
                <div>
                    <label class="form-label">Visibility</label>
                    <select name="visibility" class="form-control">
                        <option value="public">Public</option>
                        <option value="members">Members Only</option>
                    </select>
                </div>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <label class="form-label">Publish Date (Optional)</label>
                    <input type="datetime-local" name="published_at" class="form-control">
                    <small>Leave blank to publish immediately if status is published.</small>
                </div>
                <div style="display: flex; align-items: center; padding-top: 1.5rem;">
                     <input type="checkbox" name="is_featured" id="is_featured" value="1">
                     <label for="is_featured" style="margin-left: 0.5rem;">Feature this Statement</label>
                </div>
            </div>

            <div style="margin-bottom: 1rem; border: 1px dashed #ccc; padding: 1rem; border-radius: 4px;">
                <label class="form-label">Attachments (PDF, DOC, Images)</label>
                <input type="file" name="attachments[]" class="form-control" multiple>
            </div>

            <div style="text-align: right; margin-top: 2rem;">
                <a href="{{ route('admin.resources.press.index') }}" class="btn" style="background: #ccc; margin-right: 1rem; text-decoration: none; color: black;">Cancel</a>
                <button type="submit" class="btn btn-primary">Create Release</button>
            </div>
        </form>
    </div>

    <!-- Quill Styles and Script -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        var quill = new Quill('#editor-container', {
            theme: 'snow',
            placeholder: 'Write the press release content here...',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    ['blockquote', 'code-block'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    [{ 'script': 'sub'}, { 'script': 'super' }],
                    [{ 'indent': '-1'}, { 'indent': '+1' }],
                    [{ 'direction': 'rtl' }],
                    [{ 'size': ['small', false, 'large', 'huge'] }],
                    [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                    [{ 'color': [] }, { 'background': [] }],
                    [{ 'font': [] }],
                    [{ 'align': [] }],
                    ['link', 'image', 'video'],
                    ['clean']
                ]
            }
        });

        document.querySelector('form').onsubmit = function() {
            var body = document.querySelector('input[name=body]');
            body.value = quill.root.innerHTML;
            
            if (quill.getText().trim().length === 0) {
                alert('Please enter a body for the press release.');
                return false;
            }
        };
    </script>
@endsection
