@extends('layouts.admin')

@section('title', $document->title)

@section('content')
    <div class="header">
        <div>
            <h1>{{ $document->title }}</h1>
            <div style="display: flex; gap: 0.5rem; margin-top: 0.5rem;">
                <span class="badge" style="background: #eef2ff; color: #4338ca;">{{ $document->category->name ?? 'Uncategorized' }}</span>
                <span class="badge" style="background: #f1f5f9; color: #64748b;">
                    {{ ucfirst($document->access_level) }}
                    @if($document->access_level === 'restricted')
                         ({{ implode(', ', $document->allowed_roles ?? []) }})
                    @endif
                </span>
            </div>
        </div>
        <div style="display: flex; gap: 1rem;">
            <a href="{{ route('admin.resources.documents.index') }}" class="btn" style="background: white; border: 1px solid #ccc;">Back</a>
            <a href="{{ route('admin.resources.documents.edit', $document->id) }}" class="btn btn-primary">Edit Details</a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
        
        <!-- Versions History -->
        <div class="card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h3>Version History</h3>
            </div>
            
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="text-align: left; border-bottom: 1px solid #eee;">
                        <th style="padding: 0.5rem;">Version</th>
                        <th style="padding: 0.5rem;">Date</th>
                        <th style="padding: 0.5rem;">Uploaded By</th>
                        <th style="padding: 0.5rem;">Notes</th>
                        <th style="padding: 0.5rem;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($document->versions as $index => $version)
                        <tr style="border-bottom: 1px solid #f5f5f5;">
                            <td style="padding: 0.75rem;">
                                <strong>v{{ $document->versions->count() - $index }}</strong>
                            </td>
                            <td style="padding: 0.75rem;">{{ $version->created_at->format('M d, Y H:i') }}</td>
                            <td style="padding: 0.75rem;">{{ $version->uploader->name ?? 'Unknown' }}</td>
                            <td style="padding: 0.75rem; color: #666;">{{ $version->version_notes }}</td>
                            <td style="padding: 0.75rem;">
                                <a href="{{ Storage::url($version->file_path) }}" target="_blank" class="btn" style="padding: 2px 8px; font-size: 0.8rem; background: #e0e7ff; color: #4338ca;">Download</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Sidebar Actions -->
        <div>
            <!-- Upload New Version -->
            <div class="card" style="margin-bottom: 2rem;">
                <h3 style="margin-bottom: 1rem;">Upload New Version</h3>
                <form action="{{ route('admin.resources.documents.version.store', $document->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div style="margin-bottom: 1rem;">
                        <label class="form-label">New File</label>
                        <input type="file" name="file" class="form-control" required>
                    </div>
                    <div style="margin-bottom: 1rem;">
                        <label class="form-label">Change Notes</label>
                        <input type="text" name="version_notes" class="form-control" placeholder="What changed?" required>
                    </div>
                    <button type="submit" class="btn btn-primary" style="width: 100%;">Upload Version</button>
                    <small style="display: block; margin-top: 0.5rem; color: #777;">This will become the active version (v{{ $document->versions->count() + 1 }}).</small>
                </form>
            </div>

            <!-- Description -->
            <div class="card">
                <h3 style="margin-bottom: 0.5rem;">Description</h3>
                <p style="color: #4b5563; line-height: 1.5;">{{ $document->description ?? 'No description provided.' }}</p>
                
                <div style="margin-top: 2rem; border-top: 1px solid #eee; padding-top: 1rem;">
                     <form action="{{ route('admin.resources.documents.destroy', $document->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this document and all versions?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" style="width: 100%;">Delete Document</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
