@extends('layouts.admin')

@section('title', 'Documents')

@section('content')
    <div class="header">
        <div>
            <h1>Documents</h1>
            <p>Manage organizational documents, policies, and agreements.</p>
        </div>
        <div style="display: flex; gap: 1rem;">
            <a href="{{ route('admin.resources.document-categories.index') }}" class="btn" style="background: var(--dark-light); color: white;">Manage Categories</a>
            <a href="{{ route('admin.resources.documents.create') }}" class="btn btn-primary">Upload Document</a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card">
        <div style="margin-bottom: 1.5rem; display: flex; gap: 1rem; align-items: center;">
            <form method="GET" action="{{ route('admin.resources.documents.index') }}" style="display: flex; gap: 0.5rem; align-items: center;">
                <select name="category_id" class="form-control" style="width: 200px;" onchange="this.form.submit()">
                    <option value="">All Categories</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
                @if(request('category_id'))
                    <a href="{{ route('admin.resources.documents.index') }}" style="color: var(--danger); font-size: 0.9rem; text-decoration: none;">Clear Filter</a>
                @endif
            </form>
        </div>

        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Category</th>
                    <th style="padding: 1rem;">Access</th>
                    <th style="padding: 1rem;">Latest Version</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($documents as $doc)
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: 600;">{{ $doc->title }}</div>
                            <div style="font-size: 0.8rem; color: #777;">{{ Str::limit($doc->description, 50) }}</div>
                        </td>
                        <td style="padding: 1rem;">
                            @if($doc->category)
                                <span class="badge" style="background: #eef2ff; color: #4338ca;">{{ $doc->category->name }}</span>
                            @else
                                <span style="color: #ccc;">Uncategorized</span>
                            @endif
                        </td>
                        <td style="padding: 1rem;">
                            @if($doc->access_level === 'public')
                                <span class="badge" style="background: #dcfce7; color: #16a34a;">Public</span>
                            @elseif($doc->access_level === 'members')
                                <span class="badge" style="background: #dbeafe; color: #2563eb;">Members Only</span>
                            @else
                                <span class="badge" style="background: #fee2e2; color: #dc2626;">Restricted</span>
                            @endif
                        </td>
                        <td style="padding: 1rem; font-size: 0.9rem;">
                            @if($doc->latestVersion)
                                <div>v{{ $doc->versions->count() }}</div>
                                <div style="color: #777; font-size: 0.8rem;">
                                    {{ $doc->latestVersion->created_at->format('M d, Y') }}
                                </div>
                            @else
                                <span style="color: #ccc;">-</span>
                            @endif
                        </td>
                        <td style="padding: 1rem;">
                            <a href="{{ route('admin.resources.documents.show', $doc->id) }}" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Manage</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No documents found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            {{ $documents->withQueryString()->links() }}
        </div>
    </div>
@endsection
