@extends('layouts.admin')

@section('title', 'Edit Document')

@section('content')
    <div class="header">
        <h1>Edit Document Details</h1>
    </div>

    <div class="card" style="max-width: 800px;">
        <form action="{{ route('admin.resources.documents.update', $document->id) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" required value="{{ $document->title }}">
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <label class="form-label">Category</label>
                    <select name="category_id" class="form-control" required>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ $document->category_id == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                     <label class="form-label">Access Level</label>
                     <select name="access_level" class="form-control" onchange="toggleRoles(this.value)">
                         <option value="public" {{ $document->access_level == 'public' ? 'selected' : '' }}>Public</option>
                         <option value="members" {{ $document->access_level == 'members' ? 'selected' : '' }}>Members Only</option>
                         <option value="restricted" {{ $document->access_level == 'restricted' ? 'selected' : '' }}>Restricted</option>
                     </select>
                </div>
            </div>

            <div id="roles-container" style="margin-bottom: 1rem; display: {{ $document->access_level == 'restricted' ? 'block' : 'none' }}; background: #f9f9f9; padding: 1rem; border-radius: 8px;">
                <label class="form-label">Allowed Roles</label>
                <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
                     <label><input type="checkbox" name="allowed_roles[]" value="Official" {{ in_array('Official', $document->allowed_roles ?? []) ? 'checked' : '' }}> Official</label>
                     <label><input type="checkbox" name="allowed_roles[]" value="Shop Steward" {{ in_array('Shop Steward', $document->allowed_roles ?? []) ? 'checked' : '' }}> Shop Steward</label>
                </div>
            </div>

            <div style="margin-bottom: 1rem;">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-control" rows="3">{{ $document->description }}</textarea>
            </div>
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Status</label>
                <select name="status" class="form-control">
                    <option value="active" {{ $document->status == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="archived" {{ $document->status == 'archived' ? 'selected' : '' }}>Archived</option>
                </select>
            </div>

            <div style="text-align: right; margin-top: 2rem;">
                <a href="{{ route('admin.resources.documents.show', $document->id) }}" class="btn" style="background: #ccc; margin-right: 1rem; text-decoration: none; color: black;">Cancel</a>
                <button type="submit" class="btn btn-primary">Update Details</button>
            </div>
        </form>
    </div>

    <script>
        function toggleRoles(value) {
            document.getElementById('roles-container').style.display = value === 'restricted' ? 'block' : 'none';
        }
    </script>
@endsection
