@extends('layouts.admin')

@section('title', 'Upload Document')

@section('content')
    <div class="header">
        <h1>Upload Document</h1>
        <a href="{{ route('admin.resources.documents.index') }}" class="btn" style="background: white; border: 1px solid #ccc;">Back</a>
    </div>

    <div class="card" style="max-width: 800px;">
        <form action="{{ route('admin.resources.documents.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div style="margin-bottom: 2rem;">
                <h3 style="margin-bottom: 1rem; border-bottom: 1px solid #eee; padding-bottom: 0.5rem;">Document Details</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" required placeholder="e.g. Constitution 2025">
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                    <div>
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-control" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                         <label class="form-label">Access Level</label>
                         <select name="access_level" class="form-control" onchange="toggleRoles(this.value)">
                             <option value="public">Public (Everyone)</option>
                             <option value="members">Members Only</option>
                             <option value="restricted">Restricted (Specific Roles)</option>
                         </select>
                    </div>
                </div>

                <div id="roles-container" style="margin-bottom: 1rem; display: none; background: #f9f9f9; padding: 1rem; border-radius: 8px;">
                    <label class="form-label">Allowed Roles</label>
                    <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
                         <label><input type="checkbox" name="allowed_roles[]" value="Official"> Official</label>
                         <label><input type="checkbox" name="allowed_roles[]" value="Shop Steward"> Shop Steward</label>
                    </div>
                </div>

                <div style="margin-bottom: 1rem;">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                </div>
            </div>

            <div style="margin-bottom: 2rem;">
                <h3 style="margin-bottom: 1rem; border-bottom: 1px solid #eee; padding-bottom: 0.5rem;">Initial Version</h3>
                
                <div style="margin-bottom: 1rem;">
                    <label class="form-label">File Upload</label>
                    <input type="file" name="file" class="form-control" required>
                    <small>Supported: PDF, DOCX. Max 20MB.</small>
                </div>

                 <div style="margin-bottom: 1rem;">
                    <label class="form-label">Version Notes (Optional)</label>
                    <input type="text" name="version_notes" class="form-control" placeholder="e.g. Initial draft">
                </div>
            </div>

            <div style="text-align: right;">
                <button type="submit" class="btn btn-primary">Upload Document</button>
            </div>
        </form>
    </div>

    <script>
        function toggleRoles(value) {
            document.getElementById('roles-container').style.display = value === 'restricted' ? 'block' : 'none';
        }
    </script>
@endsection
