@extends('layouts.admin')

@section('title', 'Document Categories')

@section('content')
    <div class="header">
        <h1>Document Categories</h1>
        <a href="{{ route('admin.resources.documents.index') }}" class="btn" style="background: white; border: 1px solid #ccc;">Back to Documents</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger" style="background: #fee2e2; color: #991b1b; padding: 1rem; border-radius: 8px;">{{ session('error') }}</div>
    @endif

    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
        <div class="card">
            <h3 style="margin-bottom: 1rem;">All Categories</h3>
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="text-align: left; border-bottom: 1px solid #eee;">
                        <th style="padding: 0.5rem;">Name</th>
                        <th style="padding: 0.5rem;">Documents</th>
                        <th style="padding: 0.5rem;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($categories as $category)
                        <tr style="border-bottom: 1px solid #f5f5f5;">
                            <td style="padding: 0.75rem;">
                                <strong>{{ $category->name }}</strong>
                                <div style="font-size: 0.8rem; color: #777;">{{ $category->description }}</div>
                            </td>
                            <td style="padding: 0.75rem;">{{ $category->documents_count }}</td>
                            <td style="padding: 0.75rem;">
                                <form action="{{ route('admin.resources.document-categories.destroy', $category->id) }}" method="POST" onsubmit="return confirm('Delete category?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn" style="padding: 2px 6px; font-size: 0.8rem; color: #ef4444; border: 1px solid #ef4444; background: white;">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="3" style="padding: 1rem; text-align: center;">No categories yet.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="card" style="height: fit-content;">
            <h3 style="margin-bottom: 1rem;">Add New Category</h3>
            <form action="{{ route('admin.resources.document-categories.store') }}" method="POST">
                @csrf
                <div style="margin-bottom: 1rem;">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="2"></textarea>
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%;">Create Category</button>
            </form>
        </div>
    </div>
@endsection
