@extends('layouts.admin')

@section('title', 'Organization Settings | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1 style="margin: 0;">Organization Master Data</h1>
        <p>Manage Provinces, Regions, and Branches.</p>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success">
    {{ session('success') }}
</div>
@endif

@if($errors->any())
<div class="alert alert-danger">
    <ul>
        @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="card">
    <div class="tabs" style="border-bottom: 1px solid #e2e8f0; display: flex; gap: 1rem; padding: 0 1.5rem;">
        <button class="tab-btn active" onclick="openTab(event, 'provinces')" style="padding: 1rem; border: none; background: none; color: #4f46e5; border-bottom: 2px solid #4f46e5; font-weight: 500; cursor: pointer;">Provinces</button>
        <button class="tab-btn" onclick="openTab(event, 'regions')" style="padding: 1rem; border: none; background: none; color: #64748b; border-bottom: 2px solid transparent; font-weight: 500; cursor: pointer;">Regions</button>
        <button class="tab-btn" onclick="openTab(event, 'branches')" style="padding: 1rem; border: none; background: none; color: #64748b; border-bottom: 2px solid transparent; font-weight: 500; cursor: pointer;">Branches</button>
    </div>

    <!-- Provinces Tab -->
    <div id="provinces" class="tab-content" style="padding: 2rem;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
            <h3>Provinces</h3>
            <button class="btn btn-primary" onclick="showModal('provinceModal')">Add Province</button>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Code</th>
                    <th>Regions</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($provinces as $province)
                <tr>
                    <td>{{ $province->name }}</td>
                    <td>{{ $province->code }}</td>
                    <td>{{ $province->regions->count() }}</td>
                    <td>
                        <button class="btn btn-sm" onclick="editProvince({{ $province }})" style="color: #4f46e5;">Edit</button>
                        <form action="{{ route('admin.organization.provinces.destroy', $province) }}" method="POST" style="display: inline-block; margin-left: 0.5rem;" onsubmit="return confirm('Are you sure?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm" style="color: #ef4444; background: none; border: none; padding: 0; cursor: pointer;">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Regions Tab -->
    <div id="regions" class="tab-content" style="padding: 2rem; display: none;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
            <h3>Regions</h3>
            <button class="btn btn-primary" onclick="showModal('regionModal')">Add Region</button>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Province</th>
                    <th>Branches</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($regions as $region)
                <tr>
                    <td>{{ $region->name }}</td>
                    <td>{{ $region->province->name }}</td>
                    <td>{{ $region->branches->count() }}</td>
                    <td>
                        <button class="btn btn-sm" onclick="editRegion({{ $region }})" style="color: #4f46e5;">Edit</button>
                        <form action="{{ route('admin.organization.regions.destroy', $region) }}" method="POST" style="display: inline-block; margin-left: 0.5rem;" onsubmit="return confirm('Are you sure?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm" style="color: #ef4444; background: none; border: none; padding: 0; cursor: pointer;">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Branches Tab -->
    <div id="branches" class="tab-content" style="padding: 2rem; display: none;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
            <h3>Branches</h3>
            <button class="btn btn-primary" onclick="showModal('branchModal')">Add Branch</button>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Code</th>
                    <th>Region</th>
                    <th>Province</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($branches as $branch)
                <tr>
                    <td>{{ $branch->name }}</td>
                    <td>{{ $branch->code }}</td>
                    <td>{{ $branch->region->name }}</td>
                    <td>{{ $branch->region->province->name }}</td>
                    <td>
                        <button class="btn btn-sm" onclick="editBranch({{ $branch }})" style="color: #4f46e5;">Edit</button>
                        <form action="{{ route('admin.organization.branches.destroy', $branch) }}" method="POST" style="display: inline-block; margin-left: 0.5rem;" onsubmit="return confirm('Are you sure?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm" style="color: #ef4444; background: none; border: none; padding: 0; cursor: pointer;">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Modals -->
<!-- Province Modal -->
<div id="provinceModal" class="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; padding: 2rem; border-radius: 8px; width: 400px; max-width: 90%;">
        <h3 id="provinceModalTitle" style="margin-top: 0;">Add Province</h3>
        <form id="provinceForm" action="{{ route('admin.organization.provinces.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" value="POST" id="provinceMethod">
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Name</label>
                <input type="text" name="name" id="provinceName" class="form-control" required>
            </div>
            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Code</label>
                <input type="text" name="code" id="provinceCode" class="form-control" maxlength="10">
            </div>
            <div style="display: flex; justify-content: flex-end; gap: 0.5rem;">
                <button type="button" class="btn" style="background: #f1f5f9; color: #475569;" onclick="closeModal('provinceModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

<!-- Region Modal -->
<div id="regionModal" class="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; padding: 2rem; border-radius: 8px; width: 400px; max-width: 90%;">
        <h3 id="regionModalTitle" style="margin-top: 0;">Add Region</h3>
        <form id="regionForm" action="{{ route('admin.organization.regions.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" value="POST" id="regionMethod">
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Name</label>
                <input type="text" name="name" id="regionName" class="form-control" required>
            </div>
            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Province</label>
                <select name="province_id" id="regionProvince" class="form-control" required>
                    <option value="">Select Province</option>
                    @foreach($provinces as $province)
                    <option value="{{ $province->id }}">{{ $province->name }}</option>
                    @endforeach
                </select>
            </div>
            <div style="display: flex; justify-content: flex-end; gap: 0.5rem;">
                <button type="button" class="btn" style="background: #f1f5f9; color: #475569;" onclick="closeModal('regionModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

<!-- Branch Modal -->
<div id="branchModal" class="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; padding: 2rem; border-radius: 8px; width: 400px; max-width: 90%;">
        <h3 id="branchModalTitle" style="margin-top: 0;">Add Branch</h3>
        <form id="branchForm" action="{{ route('admin.organization.branches.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" value="POST" id="branchMethod">
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Name</label>
                <input type="text" name="name" id="branchName" class="form-control" required>
            </div>
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Code</label>
                <input type="text" name="code" id="branchCode" class="form-control">
            </div>
            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Region</label>
                <select name="region_id" id="branchRegion" class="form-control" required>
                    <option value="">Select Region</option>
                    @foreach($regions as $region)
                    <option value="{{ $region->id }}">{{ $region->name }} ({{ $region->province->code }})</option>
                    @endforeach
                </select>
            </div>
            <div style="display: flex; justify-content: flex-end; gap: 0.5rem;">
                <button type="button" class="btn" style="background: #f1f5f9; color: #475569;" onclick="closeModal('branchModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

<script>
    function openTab(evt, tabName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tab-content");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
        }
        tablinks = document.getElementsByClassName("tab-btn");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
            tablinks[i].style.color = "#64748b";
            tablinks[i].style.borderBottomColor = "transparent";
        }
        document.getElementById(tabName).style.display = "block";
        evt.currentTarget.className += " active";
        evt.currentTarget.style.color = "#4f46e5";
        evt.currentTarget.style.borderBottomColor = "#4f46e5";
    }

    function showModal(id) {
        document.getElementById(id).style.display = "flex";
        // Reset form for add
        if(id === 'provinceModal') {
            document.getElementById('provinceForm').action = "{{ route('admin.organization.provinces.store') }}";
            document.getElementById('provinceMethod').value = "POST";
            document.getElementById('provinceTitle').innerText = "Add Province";
            document.getElementById('provinceName').value = "";
            document.getElementById('provinceCode').value = "";
        } else if (id === 'regionModal') {
            document.getElementById('regionForm').action = "{{ route('admin.organization.regions.store') }}";
            document.getElementById('regionMethod').value = "POST";
            document.getElementById('regionTitle').innerText = "Add Region";
            document.getElementById('regionName').value = "";
            document.getElementById('regionProvince').value = "";
        } else if (id === 'branchModal') {
            document.getElementById('branchForm').action = "{{ route('admin.organization.branches.store') }}";
            document.getElementById('branchMethod').value = "POST";
            document.getElementById('branchTitle').innerText = "Add Branch";
            document.getElementById('branchName').value = "";
            document.getElementById('branchCode').value = "";
            document.getElementById('branchRegion').value = "";
        }
    }

    function closeModal(id) {
        document.getElementById(id).style.display = "none";
    }

    function editProvince(province) {
        showModal('provinceModal');
        document.getElementById('provinceForm').action = "/admin/organization/provinces/" + province.id;
        document.getElementById('provinceMethod').value = "PUT";
        document.getElementById('provinceModalTitle').innerText = "Edit Province";
        document.getElementById('provinceName').value = province.name;
        document.getElementById('provinceCode').value = province.code;
    }

    function editRegion(region) {
        showModal('regionModal');
        document.getElementById('regionForm').action = "/admin/organization/regions/" + region.id;
        document.getElementById('regionMethod').value = "PUT";
        document.getElementById('regionModalTitle').innerText = "Edit Region";
        document.getElementById('regionName').value = region.name;
        document.getElementById('regionProvince').value = region.province_id;
    }

    function editBranch(branch) {
        showModal('branchModal');
        document.getElementById('branchForm').action = "/admin/organization/branches/" + branch.id;
        document.getElementById('branchMethod').value = "PUT";
        document.getElementById('branchModalTitle').innerText = "Edit Branch";
        document.getElementById('branchName').value = branch.name;
        document.getElementById('branchCode').value = branch.code;
        document.getElementById('branchRegion').value = branch.region_id;
    }
</script>
@endsection
