@extends('layouts.admin')

@section('title', $message->title . ' | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <div style="display: flex; align-items: center; gap: 1rem;">
            <a href="{{ route('admin.messages.index') }}" style="color: #64748b; text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 12H5m7-7l-7 7 7 7"></path></svg>
                Back
            </a>
            <h1 style="margin: 0;">{{ $message->title }}</h1>
        </div>
        <p style="margin-top: 0.5rem; color: #64748b;">
            Sent on {{ $message->published_at ? $message->published_at->format('F d, Y \a\t H:i') : 'Draft' }}
        </p>
    </div>
    <div style="display: flex; gap: 0.5rem;">
        @if($message->status === 'published')
        <form action="{{ route('admin.messages.resend', $message) }}" method="POST" onsubmit="return confirm('Resend notification?');">
            @csrf
            <button type="submit" class="btn" style="background: white; border: 1px solid #e2e8f0; color: #4338ca;">
                Resend Notification
            </button>
        </form>
        @endif
        <a href="{{ route('admin.messages.edit', $message) }}" class="btn btn-primary">
            Edit Message
        </a>
    </div>
</div>

<div class="card" style="max-width: 800px; padding: 2rem;">
    <!-- Metadata Badges -->
    <div style="display: flex; gap: 1rem; margin-bottom: 2rem; border-bottom: 1px solid #f1f5f9; padding-bottom: 1.5rem;">
        <div>
            <span style="font-size: 0.8rem; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.5px;">Type</span>
            <div style="margin-top: 0.25rem;">
                <span class="badge" style="background: rgba(79, 70, 229, 0.1); color: #4338ca;">{{ ucfirst($message->type) }}</span>
            </div>
        </div>
        <div>
            <span style="font-size: 0.8rem; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.5px;">Audience</span>
            <div style="margin-top: 0.25rem; font-weight: 500; color: #0f172a;">
                @if($message->recipient_type === 'all')
                    All Members
                @elseif($message->recipient_type === 'individual')
                    Individual (ID: {{ $message->receiver_id }})
                @elseif($message->recipient_type === 'segment')
                    Segmented Group
                    <!-- Could loop through targeting_criteria to show specifics -->
                @endif
            </div>
        </div>
        </div>
        <div>
            <span style="font-size: 0.8rem; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.5px;">Channels</span>
            <div style="margin-top: 0.25rem;">
                @foreach($message->channels ?? ['in_app'] as $channel)
                    <span class="badge" style="background: #f1f5f9; color: #475569; margin-right: 4px;">
                        @if($channel == 'in_app') In-App @elseif($channel == 'push') Push @elseif($channel == 'email') Email @endif
                    </span>
                @endforeach
            </div>
        </div>
        <div>
            <span style="font-size: 0.8rem; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.5px;">Status</span>
            <div style="margin-top: 0.25rem;">
                @if($message->status === 'published')
                    <span class="badge badge-success">Published</span>
                    <div style="font-size: 0.75rem; color: #64748b; margin-top: 4px;">{{ $message->published_at ? $message->published_at->format('M d, Y H:i') : '' }}</div>
                @elseif($message->status === 'scheduled')
                    <span class="badge" style="background: rgba(59, 130, 246, 0.1); color: #2563eb;">Scheduled</span>
                    <div style="font-size: 0.75rem; color: #64748b; margin-top: 4px;">For {{ $message->published_at ? $message->published_at->format('M d, Y H:i') : '' }}</div>
                @else
                    <span class="badge" style="background: rgba(245, 158, 11, 0.1); color: #d97706;">Draft</span>
                @endif
                
                @if($message->expires_at)
                    <div style="font-size: 0.75rem; color: #ef4444; margin-top: 4px;">Expires {{ $message->expires_at->format('M d, Y H:i') }}</div>
                @endif
            </div>
        </div>
    </div>

    <!-- Message Body -->
    <div class="message-body" style="font-size: 1.05rem; line-height: 1.7; color: #334155;">
        {!! $message->content !!}
    </div>

    <!-- Attachments -->
    @if($message->attachments->count() > 0)
    <div style="margin-top: 3rem; padding-top: 1.5rem; border-top: 1px solid #f1f5f9;">
        
        <!-- Image Gallery -->
        @php
            $images = $message->attachments->filter(fn($a) => Str::startsWith($a->mime_type, 'image/'));
            $files = $message->attachments->reject(fn($a) => Str::startsWith($a->mime_type, 'image/'));
        @endphp

        @if($images->count() > 0)
        <h4 style="margin-bottom: 1rem; font-size: 1rem; color: #64748b;">Attached Images</h4>
        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 2rem;">
            @foreach($images as $image)
            <div style="border: 1px solid #e2e8f0; border-radius: 8px; overflow: hidden;">
                <a href="{{ Storage::url($image->file_path) }}" target="_blank">
                    <img src="{{ Storage::url($image->file_path) }}" alt="{{ $image->file_name }}" style="width: 100%; height: 200px; object-fit: cover; display: block;">
                </a>
                <div style="padding: 0.75rem; background: #f8fafc; border-top: 1px solid #e2e8f0; font-size: 0.85rem; color: #64748b; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                    {{ $image->file_name }}
                </div>
            </div>
            @endforeach
        </div>
        @endif

        <!-- Other Files -->
        @if($files->count() > 0)
        <h4 style="margin-bottom: 1rem; font-size: 1rem; color: #64748b;">Attached Documents</h4>
        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 1rem;">
            @foreach($files as $attachment)
            <a href="{{ Storage::url($attachment->file_path) }}" target="_blank" style="text-decoration: none; color: inherit;">
                <div style="border: 1px solid #e2e8f0; border-radius: 8px; padding: 1rem; display: flex; align-items: center; gap: 0.75rem; transition: all 0.2s; background: #f8fafc;">
                    <div style="background: #e0e7ff; color: #4338ca; padding: 0.5rem; border-radius: 6px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>
                    </div>
                    <div style="overflow: hidden;">
                        <div style="font-weight: 500; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">{{ $attachment->file_name }}</div>
                        <div style="font-size: 0.8rem; color: #94a3b8;">{{ round($attachment->file_size / 1024, 1) }} KB</div>
                    </div>
                </div>
            </a>
            @endforeach
        </div>
        @endif
    </div>
    @endif
</div>
@endsection
