@extends('layouts.admin')

@section('title', 'Communication | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1>Communication</h1>
        <p>Manage announcements, alerts, and circulars.</p>
    </div>
    <div style="display: flex; gap: 10px;">
        <a href="{{ route('admin.messages.create') }}" class="btn btn-primary">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
            Compose Message
        </a>
    </div>
</div>

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<div class="card">
    <div class="card-header">
        <h3>Recent Messages</h3>
    </div>
    
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 1px solid #f1f5f9; color: #64748b; font-size: 0.85rem;">
                <th style="padding: 1rem;">Title</th>
                <th style="padding: 1rem;">Type</th>
                <th style="padding: 1rem;">Status</th>
                <th style="padding: 1rem;">Date</th>
                <th style="padding: 1rem;">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($messages as $message)
            <tr style="border-bottom: 1px solid #f1f5f9;">
                <td style="padding: 1rem; font-weight: 500;">
                    <a href="{{ route('admin.messages.show', $message) }}" style="text-decoration: none; color: #0f172a; display: block;">
                        {{ $message->title }}
                    </a>
                    <div style="font-size: 0.8rem; color: #94a3b8; font-weight: 400; margin-top: 2px;">
                        To: {{ $message->receiver ? $message->receiver->name : 'All Members' }}
                    </div>
                </td>
                <td style="padding: 1rem;">
                    <span class="badge" style="background: rgba(79, 70, 229, 0.1); color: #4338ca;">{{ ucfirst($message->type) }}</span>
                    <div style="margin-top: 5px; display: flex; gap: 4px;">
                        @foreach($message->channels ?? ['in_app'] as $channel)
                            @if($channel == 'push')
                                <span title="Push Notification" style="color: #64748b;"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path><path d="M13.73 21a2 2 0 0 1-3.46 0"></path></svg></span>
                            @elseif($channel == 'email')
                                <span title="Email" style="color: #64748b;"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="4"></circle><path d="M16 8v5a3 3 0 0 0 6 0v-1a10 10 0 1 0-3.92 7.94"></path></svg></span>
                            @elseif($channel == 'in_app')
                                <span title="In-App" style="color: #64748b;"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg></span>
                            @endif
                        @endforeach
                    </div>
                </td>
                <td style="padding: 1rem;">
                    @if($message->status === 'published')
                        <span class="badge badge-success">Published</span>
                        <div style="font-size: 0.75rem; color: #64748b; margin-top: 4px;">
                            {{ $message->published_at ? $message->published_at->format('M d, Y') : '' }}
                        </div>
                    @elseif($message->status === 'scheduled')
                         <span class="badge" style="background: rgba(59, 130, 246, 0.1); color: #2563eb;">Scheduled</span>
                         <div style="font-size: 0.75rem; color: #64748b; margin-top: 4px;">
                            {{ $message->published_at ? $message->published_at->format('M d, H:i') : '' }}
                        </div>
                    @else
                        <span class="badge" style="background: rgba(245, 158, 11, 0.1); color: #d97706;">Draft</span>
                    @endif

                    @if($message->expires_at && $message->expires_at > now())
                        <div style="font-size: 0.7rem; color: #ef4444; margin-top: 4px; font-weight: 500;">
                            Expires {{ $message->expires_at->format('M d') }}
                        </div>
                    @endif
                </td>
                <td style="padding: 1rem; color: #64748b; font-size: 0.9rem;">
                    {{ $message->created_at->format('M d, Y') }}
                </td>
                <td style="padding: 1rem; display: flex; gap: 0.5rem;">
                    @if($message->status === 'published')
                    <form action="{{ route('admin.messages.resend', $message) }}" method="POST" onsubmit="return confirm('Resend notification to all recipients?');">
                        @csrf
                        <button type="submit" class="btn" style="padding: 0.4rem; color: #4338ca;" title="Resend Notification">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21.5 2v6h-6M21.34 5.5A10 10 0 1 0 22 12"></path></svg>
                        </button>
                    </form>
                    @endif
                    
                    <a href="{{ route('admin.messages.edit', $message) }}" class="btn" style="padding: 0.4rem; color: #64748b;" title="Edit">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
                    </a>

                    <form action="{{ route('admin.messages.destroy', $message) }}" method="POST" onsubmit="return confirm('Archive this message?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn" style="padding: 0.4rem; color: #d97706;" title="Archive">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="21 8 21 21 3 21 3 8"></polyline><line x1="1" y1="3" x2="23" y2="3"></line><line x1="10" y1="12" x2="14" y2="12"></line></svg>
                        </button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="5" style="padding: 2rem; text-align: center; color: #94a3b8;">
                    No messages found. Start creating one!
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div style="padding: 1rem;">
        {{ $messages->links() }}
    </div>
</div>
@endsection
