@extends('layouts.admin')

@section('title', 'Edit Message | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1>Edit Message</h1>
        <p>Update Announcement or Circular</p>
    </div>
    <a href="{{ route('admin.messages.index') }}" class="btn" style="background: white; border: 1px solid #e2e8f0;">
        Cancel
    </a>
</div>

<div class="card" style="max-width: 800px;">
    <form action="{{ route('admin.messages.update', $message->id) }}" method="POST" enctype="multipart/form-data" id="messageForm">
        @csrf
        @method('PUT')
        
        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Title</label>
            <input type="text" name="title" class="form-control" value="{{ old('title', $message->title) }}" required>
        </div>

        <div style="display: flex; gap: 1.5rem; margin-bottom: 1.5rem;">
            <div style="flex: 1;">
                <label class="form-label">Message Type</label>
                <select name="type" class="form-control">
                    <option value="announcement" {{ $message->type == 'announcement' ? 'selected' : '' }}>Announcement</option>
                    <option value="alert" {{ $message->type == 'alert' ? 'selected' : '' }}>Alert</option>
                    <option value="circular" {{ $message->type == 'circular' ? 'selected' : '' }}>Circular</option>
                    <option value="reminder" {{ $message->type == 'reminder' ? 'selected' : '' }}>Reminder</option>
                    <option value="emergency" {{ $message->type == 'emergency' ? 'selected' : '' }} style="color: red; font-weight: bold;">Emergency</option>
                </select>
            </div>
            <!-- Status handled by buttons -->
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Message Body</label>
            <div id="editor-container" style="height: 300px; background: white;">{!! old('content', $message->content) !!}</div>
            <input type="hidden" name="content" id="contentInput" value="{{ $message->content }}">
        </div>

        <div style="margin-bottom: 1.5rem; background: #fff; padding: 1.5rem; border: 1px solid #e2e8f0; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Delivery Channels</label>
            <div style="display: flex; gap: 2rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="in_app" checked onclick="return false;">
                    <span>In-app Message</span>
                    <span class="badge" style="font-size: 0.65rem; background: #e2e8f0; color: #64748b;">Required</span>
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="push" {{ in_array('push', $message->channels ?? []) ? 'checked' : '' }}>
                    <span>Push Notification</span>
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="email" {{ in_array('email', $message->channels ?? []) ? 'checked' : '' }}>
                    <span>Email</span>
                </label>
            </div>
            <p style="font-size: 0.8rem; color: #94a3b8; margin-top: 0.5rem;">Select how you want to deliver this message.</p>
        </div>

        <div style="margin-bottom: 1.5rem; background: #f8fafc; padding: 1.5rem; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Audience Control</label>
            
            <div style="display: flex; gap: 2rem; margin-bottom: 1rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="all" {{ $message->recipient_type == 'all' ? 'checked' : '' }} onclick="toggleAudience('all')">
                    All Members
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="segment" {{ $message->recipient_type == 'segment' ? 'checked' : '' }} onclick="toggleAudience('segment')">
                    Specific Segment
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="individual" {{ $message->recipient_type == 'individual' ? 'checked' : '' }} onclick="toggleAudience('individual')">
                    Individual Member
                </label>
            </div>

            <!-- Segment Controls -->
            <div id="segment-controls" style="display: {{ $message->recipient_type == 'segment' ? 'block' : 'none' }}; padding-top: 1rem; border-top: 1px solid #e2e8f0; margin-top: 0.5rem;">
                @php $criteria = $message->targeting_criteria ?? []; @endphp
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label class="form-label">Branches / Webplaces</label>
                        <select name="targeting_criteria[branches][]" class="form-control" multiple>
                            <option value="Head Office" {{ in_array('Head Office', $criteria['branches'] ?? []) ? 'selected' : '' }}>Head Office</option>
                            <option value="Durban Branch" {{ in_array('Durban Branch', $criteria['branches'] ?? []) ? 'selected' : '' }}>Durban Branch</option>
                        </select>
                        <small style="color: #94a3b8;">Hold Ctrl/Cmd to select multiple</small>
                    </div>
                    <div>
                        <label class="form-label">Regions (Provinces)</label>
                        <select name="targeting_criteria[regions][]" class="form-control" multiple>
                            <option value="Gauteng" {{ in_array('Gauteng', $criteria['regions'] ?? []) ? 'selected' : '' }}>Gauteng</option>
                            <option value="KwaZulu-Natal" {{ in_array('KwaZulu-Natal', $criteria['regions'] ?? []) ? 'selected' : '' }}>KwaZulu-Natal</option>
                            <option value="Western Cape" {{ in_array('Western Cape', $criteria['regions'] ?? []) ? 'selected' : '' }}>Western Cape</option>
                        </select>
                    </div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-top: 1rem;">
                    <div>
                        <label class="form-label">Roles</label>
                        <select name="targeting_criteria[roles][]" class="form-control" multiple>
                            <option value="Shop Steward" {{ in_array('Shop Steward', $criteria['roles'] ?? []) ? 'selected' : '' }}>Shop Steward</option>
                            <option value="Official" {{ in_array('Official', $criteria['roles'] ?? []) ? 'selected' : '' }}>Official</option>
                            <option value="Member" {{ in_array('Member', $criteria['roles'] ?? []) ? 'selected' : '' }}>Member</option>
                        </select>
                    </div>
                    <div>
                         <label class="form-label">Membership Status</label>
                         <select name="targeting_criteria[status]" class="form-control">
                             <option value="">Any Status</option>
                             <option value="approved" {{ ($criteria['status'] ?? '') == 'approved' ? 'selected' : '' }}>Approved</option>
                             <option value="pending" {{ ($criteria['status'] ?? '') == 'pending' ? 'selected' : '' }}>Pending</option>
                         </select>
                    </div>
                </div>
            </div>

            <!-- Individual Controls -->
            <div id="individual-controls" style="display: {{ $message->recipient_type == 'individual' ? 'block' : 'none' }}; padding-top: 1rem; border-top: 1px solid #e2e8f0; margin-top: 0.5rem;">
                <label class="form-label">Search Member ID</label>
                <input type="number" name="targeting_criteria[receiver_id]" class="form-control" value="{{ $message->receiver_id }}" placeholder="Enter User ID (Temporary)">
            </div>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Current Attachments</label>
            @if($message->attachments->count() > 0)
                <ul style="list-style: none; padding: 0;">
                @foreach($message->attachments as $attachment)
                    <li style="margin-bottom: 0.5rem; display: flex; align-items: center; gap: 0.5rem;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>
                        <a href="{{ Storage::url($attachment->file_path) }}" target="_blank" style="text-decoration: none; color: #4f46e5;">{{ $attachment->file_name }}</a>
                    </li>
                @endforeach
                </ul>
            @else
                <p style="color: #94a3b8; font-size: 0.9rem;">No attachments.</p>
            @endif
        </div>

        <div style="margin-bottom: 1.5rem; background: #fff; padding: 1.5rem; border: 1px solid #e2e8f0; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Scheduling & Expiry</label>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
                <div>
                    <label class="form-label">Send Schedule</label>
                    <div style="margin-bottom: 0.5rem;">
                        <label style="display: inline-flex; align-items: center; gap: 0.5rem; margin-right: 1rem; cursor: pointer;">
                            <input type="radio" name="schedule_type" value="now" {{ $message->status != 'scheduled' ? 'checked' : '' }} onclick="toggleSchedule('now')">
                            Send Immediately (or Save Draft)
                        </label>
                        <label style="display: inline-flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="radio" name="schedule_type" value="later" {{ $message->status == 'scheduled' ? 'checked' : '' }} onclick="toggleSchedule('later')">
                            Schedule for Later
                        </label>
                    </div>
                    <div id="schedule-input" style="{{ $message->status == 'scheduled' ? 'display: block;' : 'display: none;' }}">
                        <input type="datetime-local" name="published_at" class="form-control" value="{{ $message->published_at ? $message->published_at->format('Y-m-d\TH:i') : '' }}">
                        <small style="color: #64748b;">Message will be sent automatically at this time.</small>
                    </div>
                </div>

                <div>
                    <label class="form-label">Expiry (Optional)</label>
                    <div style="margin-bottom: 0.5rem;">
                         <label style="display: inline-flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="checkbox" id="expiry-check" {{ $message->expires_at ? 'checked' : '' }} onclick="toggleExpiry()">
                            Set Expiry Date
                        </label>
                    </div>
                    <div id="expiry-input" style="{{ $message->expires_at ? 'display: block;' : 'display: none;' }}">
                         <input type="datetime-local" name="expires_at" class="form-control" value="{{ $message->expires_at ? $message->expires_at->format('Y-m-d\TH:i') : '' }}">
                         <small style="color: #64748b;">Message will be hidden from members after this time.</small>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Add New Attachments (PDF, Images)</label>
            <input type="file" name="attachments[]" class="form-control" multiple>
            <small style="color: #94a3b8; display: block; margin-top: 5px;">Max size: 10MB per file</small>
        </div>

        <div style="text-align: right; margin-top: 2rem; display: flex; justify-content: flex-end; gap: 1rem;">
            <button type="submit" name="action" value="draft" class="btn" style="background: #e2e8f0; color: #475569;" onclick="submitForm()">
                Save Draft
            </button>
            <button type="submit" name="action" value="published" class="btn btn-primary" onclick="submitForm()">
                {{ $message->status == 'published' ? 'Update & Resend' : 'Publish Message' }}
            </button>
        </div>
    </form>
</div>

<!-- Include Quill Styles and Script -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

<script>
    var quill = new Quill('#editor-container', {
        theme: 'snow',
        placeholder: 'Compose your message here...',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'align': [] }],
                ['link', 'image', 'video', 'clean']
            ]
        }
    });

    function toggleAudience(type) {
        document.getElementById('segment-controls').style.display = type === 'segment' ? 'block' : 'none';
        document.getElementById('individual-controls').style.display = type === 'individual' ? 'block' : 'none';
    }

    function toggleSchedule(type) {
        document.getElementById('schedule-input').style.display = type === 'later' ? 'block' : 'none';
        if (type === 'now') {
            document.querySelector('input[name="published_at"]').value = '';
        }
    }

    function toggleExpiry() {
        var isChecked = document.getElementById('expiry-check').checked;
        document.getElementById('expiry-input').style.display = isChecked ? 'block' : 'none';
        if (!isChecked) {
            document.querySelector('input[name="expires_at"]').value = '';
        }
    }
    
    function submitForm() {
        var content = document.querySelector('input[name=content]');
        content.value = quill.root.innerHTML;
    }
</script>
@endsection
