@extends('layouts.admin')

@section('title', 'Compose Message | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1>Compose Message</h1>
        <p>Create a New Announcement</p>
    </div>
    <a href="{{ route('admin.messages.index') }}" class="btn" style="background: white; border: 1px solid #e2e8f0;">
        Cancel
    </a>
</div>

<div class="card" style="max-width: 800px;">
    <form action="{{ route('admin.messages.store') }}" method="POST" enctype="multipart/form-data" id="messageForm">
        @csrf
        
        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Title</label>
            <input type="text" name="title" class="form-control" placeholder="Enter message title" required>
        </div>

        <div style="display: flex; gap: 1.5rem; margin-bottom: 1.5rem;">
            <div style="flex: 1;">
                <label class="form-label">Message Type</label>
                <select name="type" class="form-control">
                    <option value="announcement">Announcement</option>
                    <option value="alert">Alert</option>
                    <option value="circular">Circular</option>
                    <option value="reminder">Reminder</option>
                    <option value="emergency" style="color: red; font-weight: bold;">Emergency</option>
                </select>
            </div>
            
            <!-- Status removed, handled by buttons -->
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Message Body</label>
            <div id="editor-container" style="height: 300px; background: white;"></div>
            <input type="hidden" name="content" id="contentInput">
        </div>

        <div style="margin-bottom: 1.5rem; background: #fff; padding: 1.5rem; border: 1px solid #e2e8f0; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Delivery Channels</label>
            <div style="display: flex; gap: 2rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="in_app" checked onclick="return false;">
                    <span>In-app Message</span>
                    <span class="badge" style="font-size: 0.65rem; background: #e2e8f0; color: #64748b;">Required</span>
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="push">
                    <span>Push Notification</span>
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="channels[]" value="email">
                    <span>Email</span>
                </label>
            </div>
            <p style="font-size: 0.8rem; color: #94a3b8; margin-top: 0.5rem;">Select how you want to deliver this message.</p>
        </div>

        <div style="margin-bottom: 1.5rem; background: #f8fafc; padding: 1.5rem; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Audience Control</label>
            
            <div style="display: flex; gap: 2rem; margin-bottom: 1rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="all" checked onclick="toggleAudience('all')">
                    All Members
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="segment" onclick="toggleAudience('segment')">
                    Specific Segment
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="radio" name="recipient_type" value="individual" onclick="toggleAudience('individual')">
                    Individual Member
                </label>
            </div>

            <!-- Segment Controls -->
            <div id="segment-controls" style="display: none; padding-top: 1rem; border-top: 1px solid #e2e8f0; margin-top: 0.5rem;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label class="form-label">Branches / Webplaces</label>
                        <select name="targeting_criteria[branches][]" class="form-control" multiple>
                            <!-- TODO: Populate dynamically -->
                            <option value="Head Office">Head Office</option>
                            <option value="Durban Branch">Durban Branch</option>
                        </select>
                        <small style="color: #94a3b8;">Hold Ctrl/Cmd to select multiple</small>
                    </div>
                    <div>
                        <label class="form-label">Regions (Provinces)</label>
                        <select name="targeting_criteria[regions][]" class="form-control" multiple>
                            <option value="Gauteng">Gauteng</option>
                            <option value="KwaZulu-Natal">KwaZulu-Natal</option>
                            <option value="Western Cape">Western Cape</option>
                        </select>
                    </div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-top: 1rem;">
                    <div>
                        <label class="form-label">Roles</label>
                        <select name="targeting_criteria[roles][]" class="form-control" multiple>
                            <option value="Shop Steward">Shop Steward</option>
                            <option value="Official">Official</option>
                            <option value="Member">Member</option>
                        </select>
                    </div>
                    <div>
                         <label class="form-label">Membership Status</label>
                         <select name="targeting_criteria[status]" class="form-control">
                             <option value="">Any Status</option>
                             <option value="approved">Approved</option>
                             <option value="pending">Pending</option>
                         </select>
                    </div>
                </div>
            </div>

            <!-- Individual Controls -->
            <div id="individual-controls" style="display: none; padding-top: 1rem; border-top: 1px solid #e2e8f0; margin-top: 0.5rem;">
                <label class="form-label">Search Member ID</label>
                <!-- Placeholder for better search -->
                <input type="number" name="targeting_criteria[receiver_id]" class="form-control" placeholder="Enter User ID (Temporary)">
            </div>
        </div>

        <div style="margin-bottom: 1.5rem; background: #fff; padding: 1.5rem; border: 1px solid #e2e8f0; border-radius: 12px;">
            <label class="form-label" style="font-size: 1.1rem; color: #0f172a; margin-bottom: 1rem;">Scheduling & Expiry</label>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
                <div>
                    <label class="form-label">Send Schedule</label>
                    <div style="margin-bottom: 0.5rem;">
                        <label style="display: inline-flex; align-items: center; gap: 0.5rem; margin-right: 1rem; cursor: pointer;">
                            <input type="radio" name="schedule_type" value="now" checked onclick="toggleSchedule('now')">
                            Send Immediately (or Save Draft)
                        </label>
                        <label style="display: inline-flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="radio" name="schedule_type" value="later" onclick="toggleSchedule('later')">
                            Schedule for Later
                        </label>
                    </div>
                    <div id="schedule-input" style="display: none;">
                        <input type="datetime-local" name="published_at" class="form-control">
                        <small style="color: #64748b;">Message will be sent automatically at this time.</small>
                    </div>
                </div>

                <div>
                    <label class="form-label">Expiry (Optional)</label>
                    <div style="margin-bottom: 0.5rem;">
                         <label style="display: inline-flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="checkbox" id="expiry-check" onclick="toggleExpiry()">
                            Set Expiry Date
                        </label>
                    </div>
                    <div id="expiry-input" style="display: none;">
                         <input type="datetime-local" name="expires_at" class="form-control">
                         <small style="color: #64748b;">Message will be hidden from members after this time.</small>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Attachments (PDF, Images)</label>
            <input type="file" name="attachments[]" class="form-control" multiple>
            <small style="color: #94a3b8; display: block; margin-top: 5px;">Max size: 10MB per file</small>
        </div>

        <div style="text-align: right; margin-top: 2rem; display: flex; justify-content: flex-end; gap: 1rem;">
            <button type="submit" name="action" value="draft" class="btn" style="background: #e2e8f0; color: #475569;" onclick="submitForm()">
                Save Draft
            </button>
            <button type="submit" name="action" value="published" class="btn btn-primary" onclick="submitForm()">
                Send Message
            </button>
        </div>
    </form>
</div>

<!-- Include Quill Styles and Script -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

<script>
    var quill = new Quill('#editor-container', {
        theme: 'snow',
        placeholder: 'Compose your message here...',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'align': [] }],
                ['link', 'image', 'video', 'clean']
            ]
        }
    });

    // Populate hidden input on submit
    function submitForm() {
        var content = document.querySelector('input[name=content]');
        content.value = quill.root.innerHTML;
        // Optionally submit here if button type="button"
        // document.getElementById('messageForm').submit();
    }
    
    function toggleAudience(type) {
        document.getElementById('segment-controls').style.display = type === 'segment' ? 'block' : 'none';
        document.getElementById('individual-controls').style.display = type === 'individual' ? 'block' : 'none';
    }

    function toggleSchedule(type) {
        document.getElementById('schedule-input').style.display = type === 'later' ? 'block' : 'none';
        if (type === 'now') {
            document.querySelector('input[name="published_at"]').value = '';
        }
    }

    function toggleExpiry() {
        var isChecked = document.getElementById('expiry-check').checked;
        document.getElementById('expiry-input').style.display = isChecked ? 'block' : 'none';
        if (!isChecked) {
            document.querySelector('input[name="expires_at"]').value = '';
        }
    }

    // Also bind to form submit event to be safe
    document.getElementById('messageForm').onsubmit = function() {
        var content = document.querySelector('input[name=content]');
        content.value = quill.root.innerHTML;
        
        if (quill.getText().trim().length === 0) {
            alert('Please enter a message body');
            return false;
        }
    };
</script>
@endsection
