@extends('layouts.admin')

@section('title', 'Archived Messages | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <h1>Archived Messages</h1>
        <p>View and restore deleted messages.</p>
    </div>
    <a href="{{ route('admin.messages.index') }}" class="btn" style="background-color: #f1f5f9; color: #475569;">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>
        Back to Messages
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<div class="card">
    <div class="card-header">
        <h3>Archived Messages</h3>
    </div>
    
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 1px solid #f1f5f9; color: #64748b; font-size: 0.85rem;">
                <th style="padding: 1rem;">Title</th>
                <th style="padding: 1rem;">Type</th>
                <th style="padding: 1rem;">Deleted Date</th>
                <th style="padding: 1rem;">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($messages as $message)
            <tr style="border-bottom: 1px solid #f1f5f9;">
                <td style="padding: 1rem; font-weight: 500;">
                    <span style="color: #0f172a; display: block;">
                        {{ $message->title }}
                    </span>
                    <div style="font-size: 0.8rem; color: #94a3b8; font-weight: 400; margin-top: 2px;">
                        To: {{ $message->receiver ? $message->receiver->name : 'All Members' }}
                    </div>
                </td>
                <td style="padding: 1rem;">
                    <span class="badge" style="background: rgba(79, 70, 229, 0.1); color: #4338ca;">{{ ucfirst($message->type) }}</span>
                </td>
                <td style="padding: 1rem; color: #64748b; font-size: 0.9rem;">
                    {{ $message->deleted_at->format('M d, Y H:i') }}
                </td>
                <td style="padding: 1rem;">
                    <form action="{{ route('admin.messages.restore', $message->id) }}" method="POST" onsubmit="return confirm('Restore this message?');">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-success" style="padding: 0.4rem 0.8rem; color: white; background-color: #22c55e; border-radius: 4px; border: none; cursor: pointer;">
                            Restore
                        </button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="4" style="padding: 2rem; text-align: center; color: #94a3b8;">
                    No archived messages found.
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div style="padding: 1rem;">
        {{ $messages->links() }}
    </div>
</div>
@endsection
