@extends('layouts.admin')

@section('title', 'Member Contribution History')

@section('content')
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <div>
            <h1>{{ $member->name }}</h1>
            <p style="color: #666;">Contribution History & Status</p>
        </div>
        <div style="text-align: right;">
            <div style="font-size: 0.9rem; color: #666;">Current Balance</div>
            <div style="font-size: 1.5rem; font-weight: bold; color: {{ $balance > 0 ? '#dc2626' : '#16a34a' }};">
                {{ $balance > 0 ? '-R ' . number_format($balance, 2) : 'Paid Up' }}
            </div>
        </div>
    </div>

    <!-- Subscriptions Section -->
    <div class="card" style="margin-bottom: 2rem;">
        <div class="card-header">
            <h3>Active Subscriptions</h3>
        </div>
        <table class="table" style="width: 100%;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Plan</th>
                    <th style="padding: 1rem;">Amount</th>
                    <th style="padding: 1rem;">Start Date</th>
                    <th style="padding: 1rem;">Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($member->subscriptions as $sub)
                    <tr>
                        <td style="padding: 1rem;">{{ $sub->feeStructure->name }}</td>
                        <td style="padding: 1rem;">R {{ number_format($sub->feeStructure->amount, 2) }} / {{ $sub->feeStructure->frequency }}</td>
                        <td style="padding: 1rem;">{{ $sub->start_date->format('M d, Y') }}</td>
                        <td style="padding: 1rem;">{{ ucfirst($sub->status) }}</td>
                    </tr>
                @empty
                    <tr><td colspan="4" style="padding: 1rem; color: #777;">No active subscriptions.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Payments Section -->
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>Payment History</h3>
            <!-- Placeholder for Manual Payment Button -->
            <!-- <button class="btn btn-sm btn-primary">Record Payment</button> -->
        </div>
        <table class="table" style="width: 100%;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Date</th>
                    <th style="padding: 1rem;">Amount</th>
                    <th style="padding: 1rem;">Method</th>
                    <th style="padding: 1rem;">Reference</th>
                    <th style="padding: 1rem;">Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($member->payments as $payment)
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">{{ $payment->date->format('M d, Y') }}</td>
                        <td style="padding: 1rem;">R {{ number_format($payment->amount, 2) }}</td>
                        <td style="padding: 1rem;">{{ $payment->method ?? '-' }}</td>
                        <td style="padding: 1rem;">{{ $payment->reference ?? '-' }}</td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8rem; background: #eee;">
                                {{ ucfirst($payment->status) }}
                            </span>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No payment records found.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
