@extends('layouts.admin')

@section('title', 'Fee Structures')

@section('content')
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Fee Structures</h1>
        <a href="{{ route('admin.finance.fee-structures.create') }}" class="btn btn-primary">Create New Structure</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">{{ session('error') }}</div>
    @endif

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Name</th>
                    <th style="padding: 1rem;">Amount</th>
                    <th style="padding: 1rem;">Frequency</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($structures as $structure)
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem; font-weight: bold;">{{ $structure->name }}</td>
                        <td style="padding: 1rem;">R {{ number_format($structure->amount, 2) }}</td>
                        <td style="padding: 1rem;">{{ ucfirst($structure->frequency) }}</td>
                        <td style="padding: 1rem;">
                            <a href="{{ route('admin.finance.fee-structures.edit', $structure->id) }}" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">Edit</a>
                            <form action="{{ route('admin.finance.fee-structures.destroy', $structure->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Delete this structure?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #ef4444; color: white;">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" style="padding: 2rem; text-align: center; color: #777;">No fee structures defined.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
