@extends('layouts.admin')

@section('title', 'Edit Fee Structure')

@section('content')
    <div class="header">
        <h1>Edit Fee Structure</h1>
    </div>

    <div class="card" style="max-width: 600px;">
        <form action="{{ route('admin.finance.fee-structures.update', $feeStructure->id) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Name</label>
                <input type="text" name="name" class="form-control" required value="{{ $feeStructure->name }}">
            </div>

            <div style="margin-bottom: 1rem;">
                <label class="form-label">Amount (R)</label>
                <input type="number" step="0.01" name="amount" class="form-control" required value="{{ $feeStructure->amount }}">
            </div>

            <div style="margin-bottom: 1rem;">
                <label class="form-label">Frequency</label>
                <select name="frequency" class="form-control" required>
                    <option value="monthly" {{ $feeStructure->frequency == 'monthly' ? 'selected' : '' }}>Monthly</option>
                    <option value="annual" {{ $feeStructure->frequency == 'annual' ? 'selected' : '' }}>Annual</option>
                    <option value="one-time" {{ $feeStructure->frequency == 'one-time' ? 'selected' : '' }}>One-time</option>
                </select>
            </div>

            <div style="text-align: right; margin-top: 2rem;">
                <a href="{{ route('admin.finance.fee-structures.index') }}" class="btn" style="background: #ccc; margin-right: 1rem; text-decoration: none; color: black;">Cancel</a>
                <button type="submit" class="btn btn-primary">Update Structure</button>
            </div>
        </form>
    </div>
@endsection
