@extends('layouts.admin')

@section('title', 'Create Fee Structure')

@section('content')
    <div class="header">
        <h1>Create Fee Structure</h1>
    </div>

    <div class="card" style="max-width: 600px;">
        <form action="{{ route('admin.finance.fee-structures.store') }}" method="POST">
            @csrf
            
            <div style="margin-bottom: 1rem;">
                <label class="form-label">Name</label>
                <input type="text" name="name" class="form-control" required placeholder="e.g. Standard Membership">
            </div>

            <div style="margin-bottom: 1rem;">
                <label class="form-label">Amount (R)</label>
                <input type="number" step="0.01" name="amount" class="form-control" required placeholder="50.00">
            </div>

            <div style="margin-bottom: 1rem;">
                <label class="form-label">Frequency</label>
                <select name="frequency" class="form-control" required>
                    <option value="monthly">Monthly</option>
                    <option value="annual">Annual</option>
                    <option value="one-time">One-time</option>
                </select>
            </div>

            <div style="text-align: right; margin-top: 2rem;">
                <a href="{{ route('admin.finance.fee-structures.index') }}" class="btn" style="background: #ccc; margin-right: 1rem; text-decoration: none; color: black;">Cancel</a>
                <button type="submit" class="btn btn-primary">Create Structure</button>
            </div>
        </form>
    </div>
@endsection
