@extends('layouts.admin')

@section('title', 'Contributions & Subscriptions')

@section('content')
    <div class="header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h1>Contributions & Subscriptions</h1>
        <a href="{{ route('admin.finance.fee-structures.index') }}" class="btn" style="background: white; border: 1px solid #ccc; color: #333;">Manage Fee Structures</a>
    </div>

    <div class="card">
        <table class="table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; border-bottom: 1px solid #eee;">
                    <th style="padding: 1rem;">Member</th>
                    <th style="padding: 1rem;">Subscription</th>
                    <th style="padding: 1rem;">Balance</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($members as $member)
                    <tr style="border-bottom: 1px solid #f5f5f5;">
                        <td style="padding: 1rem;">
                            <div style="font-weight: bold;">{{ $member->name }}</div>
                            <div style="font-size: 0.85rem; color: #666;">{{ $member->email }}</div>
                        </td>
                        <td style="padding: 1rem;">
                            @forelse($member->subscriptions as $sub)
                                <div style="font-size: 0.9rem;">{{ $sub->feeStructure->name }} ({{ ucfirst($sub->feeStructure->frequency) }})</div>
                            @empty
                                <span style="color: #999;">No active subscription</span>
                            @endforelse
                        </td>
                        <td style="padding: 1rem;">
                            @if($member->balance > 0)
                                <span style="color: #dc2626; font-weight: bold;">-R {{ number_format($member->balance, 2) }}</span>
                            @else
                                <span style="color: #16a34a; font-weight: bold;">Paid Up</span>
                            @endif
                        </td>
                        <td style="padding: 1rem;">
                            <span class="badge" style="padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8rem;
                                background: {{ $member->status === 'Arrears' ? '#fee2e2' : '#dcfce7' }};
                                color: {{ $member->status === 'Arrears' ? '#dc2626' : '#16a34a' }};">
                                {{ $member->status }}
                            </span>
                        </td>
                        <td style="padding: 1rem;">
                            <a href="{{ route('admin.finance.member-history', $member->id) }}" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.8rem; background: #3b82f6; color: white;">View History</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: #777;">No members found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        
        <div style="padding: 1rem;">
            {{ $members->links() }}
        </div>
    </div>
@endsection
