@extends('layouts.admin')

@section('title', $event->title . ' | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <div style="display: flex; align-items: center; gap: 1rem;">
            <a href="{{ route('admin.events.index') }}" style="color: #64748b; text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 12H5m7-7l-7 7 7 7"></path></svg>
                Back
            </a>
            <h1 style="margin: 0;">{{ $event->title }}</h1>
        </div>
        <p style="margin-top: 0.5rem; color: #64748b; text-transform: capitalize;">{{ $event->event_type }}</p>
    </div>
    <div style="display: flex; gap: 0.5rem;">
         @if($event->status !== 'cancelled')
            <a href="{{ route('admin.events.edit', $event) }}" class="btn btn-primary">
                Edit Event
            </a>
            <button onclick="document.getElementById('cancel-modal').style.display = 'block'" class="btn" style="border: 1px solid #e2e8f0; color: #ef4444; background: white;">
                Cancel Event
            </button>
        @else
            <span class="badge" style="background: rgba(239, 68, 68, 0.1); color: #ef4444; font-size: 1rem; padding: 0.5rem 1rem;">Cancelled</span>
        @endif
    </div>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
    <!-- Main Content -->
    <div class="card" style="padding: 2rem;">
        <h3 style="margin-bottom: 1rem; font-size: 1.25rem;">Description</h3>
        <div class="prose" style="line-height: 1.6; color: #334155;">
            {!! $event->description !!}
        </div>

        @if($event->status === 'cancelled')
        <div style="margin-top: 2rem; padding: 1.5rem; background: #fef2f2; border: 1px solid #fee2e2; border-radius: 8px;">
            <h4 style="color: #ef4444; margin-bottom: 0.5rem;">Cancellation Reason</h4>
            <p style="color: #b91c1c;">{{ $event->cancellation_reason }}</p>
        </div>
        @endif
    </div>

    <!-- Sidebar Info -->
    <div style="display: flex; flex-direction: column; gap: 1.5rem;">
        <div class="card" style="padding: 1.5rem;">
            <h4 style="margin-bottom: 1rem; font-size: 1rem; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px;">Date & Time</h4>
            
            <div style="display: flex; gap: 0.75rem; margin-bottom: 1rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: #4f46e5;"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
                <div>
                    <div style="font-weight: 500; font-size: 1.1rem;">{{ $event->start_time->format('l, F d, Y') }}</div>
                    <div style="color: #64748b;">
                        {{ $event->start_time->format('h:i A') }} - 
                        @if($event->end_time)
                            {{ $event->end_time->format('h:i A') }}
                        @else
                            TBD
                        @endif
                    </div>
                </div>
            </div>
            
            @if($event->location)
            <h4 style="margin-bottom: 1rem; margin-top: 1.5rem; font-size: 1rem; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px;">Location</h4>
            <div style="display: flex; gap: 0.75rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: #4f46e5;"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                <div>
                    <div style="color: #0f172a;">{{ $event->location }}</div>
                </div>
            </div>
            @endif

            @if($event->virtual_link)
             <h4 style="margin-bottom: 1rem; margin-top: 1.5rem; font-size: 1rem; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px;">Online Link</h4>
            <div style="display: flex; gap: 0.75rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: #4f46e5;"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path></svg>
                <div>
                    <a href="{{ $event->virtual_link }}" target="_blank" style="color: #4f46e5; word-break: break-all;">
                        Join Meeting
                    </a>
                </div>
            </div>
            @endif

            <h4 style="margin-bottom: 1rem; margin-top: 1.5rem; font-size: 1rem; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px;">Target Audience</h4>
            <div style="display: flex; gap: 0.75rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: #4f46e5;"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                <div>
                    @php $targeting = $event->targeting ?? ['type' => 'all']; @endphp
                    <div style="color: #0f172a; font-weight: 500; text-transform: capitalize;">
                        {{ $targeting['type'] === 'all' ? 'All Members' : str_replace('_', ' ', $targeting['type']) }}
                    </div>
                    @if(($targeting['type'] ?? '') !== 'all')
                        <div style="font-size: 0.85rem; color: #64748b; margin-top: 2px;">
                            @if($targeting['type'] === 'branches' && !empty($targeting['branches']))
                                Branches: {{ \App\Models\Branch::whereIn('id', $targeting['branches'])->pluck('name')->implode(', ') }}
                            @elseif($targeting['type'] === 'regions' && !empty($targeting['regions']))
                                Regions: {{ \App\Models\Region::whereIn('id', $targeting['regions'])->pluck('name')->implode(', ') }}
                            @elseif($targeting['type'] === 'roles')
                                Roles: {{ implode(', ', array_map(fn($r) => ucfirst(str_replace('_', ' ', $r)), $targeting['roles'] ?? [])) }}
                            @endif
                        </div>
                    @endif
                    
                    @if($targeting['paid_up_only'] ?? false)
                        <div style="margin-top: 4px;">
                            <span class="badge" style="background: rgba(16, 185, 129, 0.1); color: #059669; font-size: 0.7rem;">Paid-up Only</span>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Modal -->
<div id="cancel-modal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
    <div style="background: white; padding: 2rem; border-radius: 12px; max-width: 500px; width: 100%; margin: 2rem auto;">
        <h3 style="margin-top: 0; margin-bottom: 1rem;">Cancel Event</h3>
        <p style="color: #64748b; margin-bottom: 1.5rem;">Are you sure you want to cancel this event? Please provide a reason.</p>
        
        <form action="{{ route('admin.events.cancel', $event) }}" method="POST">
            @csrf
            
            <div style="margin-bottom: 1.5rem;">
                <label class="form-label">Cancellation Reason</label>
                <textarea name="reason" rows="3" class="form-control" required placeholder="e.g. Inclement weather, Speaker unavailable..."></textarea>
            </div>
            
            <div style="display: flex; justify-content: flex-end; gap: 1rem;">
                <button type="button" onclick="document.getElementById('cancel-modal').style.display = 'none'" class="btn" style="background: #f1f5f9; color: #475569;">Close</button>
                <button type="submit" class="btn btn-primary" style="background: #ef4444; border-color: #ef4444;">Confirm Cancellation</button>
            </div>
        </form>
    </div>
</div>
@endsection
