@extends('layouts.admin')

@section('title', 'Create Event | MTWU Admin')

@section('content')
<div class="header">
    <div>
        <div style="display: flex; align-items: center; gap: 1rem;">
            <a href="{{ route('admin.events.index') }}" style="color: #64748b; text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 12H5m7-7l-7 7 7 7"></path></svg>
                Back
            </a>
            <h1 style="margin: 0;">Create New Event</h1>
        </div>
    </div>
</div>

<div class="card" style="max-width: 800px; padding: 2rem;">
    <form action="{{ route('admin.events.store') }}" method="POST" id="eventForm">
        @csrf
        
        <div class="row">
            <div class="col-md-8">
                <div style="margin-bottom: 1.5rem;">
                    <label class="form-label">Event Title <span style="color: #ef4444;">*</span></label>
                    <input type="text" name="title" class="form-control" value="{{ old('title') }}" required placeholder="e.g. Annual General Meeting">
                </div>
            </div>
            <div class="col-md-4">
                 <div style="margin-bottom: 1.5rem;">
                    <label class="form-label">Event Type <span style="color: #ef4444;">*</span></label>
                    <select name="event_type" class="form-control" required>
                        <option value="">Select Type</option>
                        <option value="meeting" {{ old('event_type') == 'meeting' ? 'selected' : '' }}>Meeting</option>
                        <option value="strike" {{ old('event_type') == 'strike' ? 'selected' : '' }}>Strike</option>
                        <option value="training" {{ old('event_type') == 'training' ? 'selected' : '' }}>Training</option>
                        <option value="rally" {{ old('event_type') == 'rally' ? 'selected' : '' }}>Rally</option>
                        <option value="workshop" {{ old('event_type') == 'workshop' ? 'selected' : '' }}>Workshop</option>
                        <option value="conference" {{ old('event_type') == 'conference' ? 'selected' : '' }}>Conference</option>
                    </select>
                </div>
            </div>
        </div>

        <div style="background: #f8fafc; padding: 1.5rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #e2e8f0;">
            <h4 style="margin-top: 0; margin-bottom: 1rem; color: #64748b; font-size: 0.95rem;">Date & Time</h4>
            <div class="row">
                <div class="col-md-6">
                    <div style="margin-bottom: 1rem;">
                        <label class="form-label">Start Date & Time <span style="color: #ef4444;">*</span></label>
                        <input type="datetime-local" name="start_time" class="form-control" value="{{ old('start_time') }}" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div style="margin-bottom: 1rem;">
                        <label class="form-label">End Date & Time</label>
                        <input type="datetime-local" name="end_time" class="form-control" value="{{ old('end_time') }}">
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-bottom: 2rem; background: #f8fafc; padding: 1.5rem; border-radius: 8px; border: 1px solid #e2e8f0;">
            <h4 style="margin-top: 0; margin-bottom: 1rem; color: #64748b; font-size: 0.95rem;">Target Audience</h4>
            
            <div style="margin-bottom: 1rem;">
                <label class="form-check-label" style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="targeting[type]" value="all" checked onchange="toggleTargeting()" style="accent-color: #4f46e5;">
                    All Members
                </label>
                
                <label class="form-check-label" style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="targeting[type]" value="branches" onchange="toggleTargeting()" style="accent-color: #4f46e5;">
                    Specific Branches
                </label>

                <div id="branches-input" style="display: none; margin-left: 1.5rem; margin-bottom: 0.5rem;">
                    <select name="targeting[branches][]" multiple class="form-control" style="height: auto;">
                        @foreach($branches as $branch)
                        <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                        @endforeach
                    </select>
                    <div style="font-size: 0.75rem; color: #64748b; margin-top: 2px;">Hold Ctrl/Cmd to select multiple</div>
                </div>
                
                <label class="form-check-label" style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="targeting[type]" value="regions" onchange="toggleTargeting()" style="accent-color: #4f46e5;">
                    Specific Regions
                </label>
                
                <div id="regions-input" style="display: none; margin-left: 1.5rem; margin-bottom: 0.5rem;">
                    <select name="targeting[regions][]" multiple class="form-control" style="height: auto;">
                        @foreach($regions as $region)
                        <option value="{{ $region->id }}">{{ $region->name }}</option>
                        @endforeach
                    </select>
                     <div style="font-size: 0.75rem; color: #64748b; margin-top: 2px;">Hold Ctrl/Cmd to select multiple</div>
                </div>

                <label class="form-check-label" style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="targeting[type]" value="roles" onchange="toggleTargeting()" style="accent-color: #4f46e5;">
                    Specific Roles
                </label>

                <div id="roles-input" style="display: none; margin-left: 1.5rem; margin-bottom: 0.5rem;">
                     <select name="targeting[roles][]" multiple class="form-control" style="height: auto;">
                        <option value="shop_steward">Shop Steward</option>
                        <option value="office_bearer">Office Bearer</option>
                        <option value="admin">Admin</option>
                    </select>
                     <div style="font-size: 0.75rem; color: #64748b; margin-top: 2px;">Hold Ctrl/Cmd to select multiple</div>
                </div>
            </div>

            <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid #e2e8f0;">
                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="targeting[paid_up_only]" value="1" style="width: 16px; height: 16px; accent-color: #4f46e5;">
                    <span style="font-weight: 500;">Paid-up Members Only</span>
                </label>
                <p style="margin: 0.25rem 0 0 1.5rem; font-size: 0.8rem; color: #64748b;">If checked, only members with "Paid Up" status will be invited.</p>
            </div>
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Physical Location</label>
            <input type="text" name="location" class="form-control" value="{{ old('location') }}" placeholder="e.g. Room 304, Union Hall, 123 Main St">
        </div>

        <div style="margin-bottom: 1.5rem;">
            <label class="form-label">Virtual Link (Optional)</label>
            <input type="url" name="virtual_link" class="form-control" value="{{ old('virtual_link') }}" placeholder="e.g. https://zoom.us/j/123456789">
        </div>

        <div style="margin-bottom: 2rem;">
            <label class="form-label">Description / Agenda</label>
            <div id="editor" style="height: 200px; background: white;"></div>
            <input type="hidden" name="description" value="{{ old('description') }}">
        </div>

        <div style="background: #f8fafc; padding: 1.5rem; border-radius: 8px; margin-bottom: 2rem; border: 1px solid #e2e8f0;">
            <h4 style="margin-top: 0; margin-bottom: 1rem; color: #64748b; font-size: 0.95rem;">Publishing</h4>
            
            <div style="margin-bottom: 1rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="publish_status" value="draft" checked onchange="toggleSchedule()" style="accent-color: #4f46e5;">
                    Save as Draft
                </label>
                
                <label style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="publish_status" value="published" onchange="toggleSchedule()" style="accent-color: #4f46e5;">
                    Publish Immediately
                </label>
                
                <label style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="radio" name="publish_status" value="scheduled" onchange="toggleSchedule()" style="accent-color: #4f46e5;">
                    Schedule for Later
                </label>
            </div>

            <div id="schedule-input" style="display: none; margin-left: 1.5rem; margin-bottom: 1rem;">
                <label class="form-label">Publish Date & Time</label>
                <input type="datetime-local" name="published_at" class="form-control" style="width: auto;">
            </div>

            <div id="notification-input" style="display: none; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid #e2e8f0;">
                 <label style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem; cursor: pointer;">
                    <input type="checkbox" name="notify_now" value="1" style="accent-color: #4f46e5;">
                    <span style="font-weight: 500;">Send Notification Now</span>
                </label>
                <div style="margin-left: 1.5rem; display: flex; gap: 1rem;">
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="notification_channels[]" value="in_app" checked style="accent-color: #4f46e5;"> In-app
                    </label>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="notification_channels[]" value="push" style="accent-color: #4f46e5;"> Push
                    </label>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="notification_channels[]" value="email" style="accent-color: #4f46e5;"> Email
                    </label>
                </div>
            </div>
        </div>

        <div style="background: #f8fafc; padding: 1.5rem; border-radius: 8px; margin-bottom: 2rem; border: 1px solid #e2e8f0;">
            <h4 style="margin-top: 0; margin-bottom: 1rem; color: #64748b; font-size: 0.95rem;">Reminders</h4>
            <div id="reminders-container"></div>
            <button type="button" class="btn btn-sm" onclick="addReminder()" style="background: #e2e8f0; color: #475569; margin-top: 0.5rem;">+ Add Reminder</button>
        </div>

        <div style="display: flex; justify-content: flex-end; gap: 1rem;">
            <a href="{{ route('admin.events.index') }}" class="btn" style="background: #f1f5f9; color: #475569;">Cancel</a>
            <button type="submit" class="btn btn-primary" onclick="submitForm()">Create Event</button>
        </div>
    </form>
</div>

<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
    var quill = new Quill('#editor', {
        theme: 'snow',
        placeholder: 'Enter event details, agenda, and speakers...',
        modules: {
            toolbar: [
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'header': [1, 2, 3, false] }],
                ['link'],
                ['clean']
            ]
        }
    });
    
    // Load old content if validation failed
    var oldContent = `{!! old('description') !!}`;
    if(oldContent) {
        quill.root.innerHTML = oldContent;
    }

    function toggleTargeting() {
        const type = document.querySelector('input[name="targeting[type]"]:checked').value;
        const branchesInput = document.getElementById('branches-input');
        const regionsInput = document.getElementById('regions-input');
        const rolesInput = document.getElementById('roles-input');
        
        branchesInput.style.display = type === 'branches' ? 'block' : 'none';
        regionsInput.style.display = type === 'regions' ? 'block' : 'none';
        rolesInput.style.display = type === 'roles' ? 'block' : 'none';
    }

    function toggleSchedule() {
        const status = document.querySelector('input[name="publish_status"]:checked').value;
        const scheduleInput = document.getElementById('schedule-input');
        const notificationInput = document.getElementById('notification-input');
        
        scheduleInput.style.display = status === 'scheduled' ? 'block' : 'none';
        notificationInput.style.display = status === 'published' ? 'block' : 'none';
    }

    let reminderIndex = 0;
    function addReminder() {
        const container = document.getElementById('reminders-container');
        const html = `
            <div class="row" style="margin-bottom: 0.5rem; align-items: center;" id="reminder-${reminderIndex}">
                <div class="col-md-3">
                    <div class="input-group">
                        <input type="number" name="reminders[${reminderIndex}][value]" class="form-control" placeholder="1" min="1" required>
                        <select name="reminders[${reminderIndex}][unit]" class="form-control" style="max-width: 100px;">
                            <option value="hours">Hours</option>
                            <option value="days">Days</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-5">
                    <div style="display: flex; gap: 1rem; align-items: center; height: 100%;">
                        <span style="font-size: 0.9rem; color: #64748b;">Before event via:</span>
                        <label style="display: flex; align-items: center; gap: 0.25rem;">
                            <input type="checkbox" name="reminders[${reminderIndex}][channels][]" value="in_app" checked> In-app
                        </label>
                        <label style="display: flex; align-items: center; gap: 0.25rem;">
                            <input type="checkbox" name="reminders[${reminderIndex}][channels][]" value="push"> Push
                        </label>
                        <label style="display: flex; align-items: center; gap: 0.25rem;">
                            <input type="checkbox" name="reminders[${reminderIndex}][channels][]" value="email"> Email
                        </label>
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="removeReminder(${reminderIndex})" style="padding: 0.25rem 0.5rem;">&times;</button>
                </div>
            </div>
        `;
        container.insertAdjacentHTML('beforeend', html);
        reminderIndex++;
    }

    function removeReminder(index) {
        document.getElementById(`reminder-${index}`).remove();
    }

    function submitForm() {
        var content = document.querySelector('input[name=description]');
        content.value = quill.root.innerHTML;
        
        // Basic validation for description if needed
        // if (quill.getText().trim().length === 0) ...
    }
    
    // Bind to form submit using event listener to ensure it runs
    document.getElementById('eventForm').addEventListener('submit', function() {
        submitForm();
    });
</script>
@endsection
